/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.internal.extensions.bpelprovider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;

import org.eclipse.stp.b2j.ui.internal.misc.StreamUtils;
import org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider.BPELProvider;
import org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider.PropertySource;
import org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider.PropertySourceUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LocalFile implements BPELProvider {

	String filename;
	PropertySource source;
	
	public PropertySourceUI getPropertySourceUI() {
		return new LocalFileUI();
	}

	public void setPropertySource(PropertySource source) {
		this.source = source;

		Document doc = source.getProperty(LocalFileUI.PROPERTY_NAME);
		Element elem = doc.getDocumentElement();
		filename = elem.getAttribute("file");
	}

	public String getBpelName() throws Exception {
		String name = filename.substring(Math.max(filename.lastIndexOf('\\'),filename.lastIndexOf('/')) + 1);
		return name;
	}

	public String getBpelSource() throws Exception {
		FileInputStream fin = new FileInputStream(filename);
		String bpel_source = StreamUtils.readAllAsString(new BufferedInputStream(fin));
		fin.close();
		
		return bpel_source;
	}

	public String getBpelUri() throws Exception {
		return new File(filename).getParentFile().toURI().toString();
	}
}