/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.WSEndpointReference;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPFactory;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPNotFoundException;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPServerTransportListener;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPUtils;
import org.eclipse.stp.b2j.core.misc.internal.XMLUtil;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Attr;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Document;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Node;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NodeList;

/**
 * 
 * @author amiguel
 *
 * A HTTP transport implementation used by the SOAP server
 */
public class SOAPServerTransportHTTP implements HTTPServerListener {

	SOAPServerTransportListener listener;
	
	boolean rpc_type = false;
	
	public SOAPServerTransportHTTP(WSEndpointReference epr, boolean rpc_type, SOAPServerTransportListener listener) throws Exception {
		this.rpc_type = rpc_type;
		this.listener = listener;
		HTTPServer.addHttpListener(new URL(epr.getAddress()),this);
	}
	public HTTPResponse doRequest(int port, String resource, String payload, HashMap lc_headers) throws HTTPException {
		
		try {
			
			//get SOAPAction from headers (if there is one)
			String soapAction = (String)lc_headers.get("soapaction");
			if (soapAction == null) {
				//This can also be called 'action'? in a later version of SOAP/HTTP binding?
				soapAction = (String)lc_headers.get("action");
			}
			String operation = null;
			String operationNamespace = null;
			
			if (soapAction == null) {
				soapAction = (String)lc_headers.get("action");
			}
			if (soapAction == null) {
				soapAction = "";
			}
	
			//remove any quotes from the soapAction header
			soapAction = soapAction.trim();
			if (soapAction.length() > 0) {
				char first = soapAction.charAt(0);
				char last = soapAction.charAt(soapAction.length()-1);
				if (first == '"' || first == '\'') {
					soapAction = soapAction.substring(1);
				}
				if (last == '"' || last == '\'') {
					soapAction = soapAction.substring(0,soapAction.length()-1);
				}
			}
			
			if (SOAPFactory.DEBUG) System.out.println("SOAP ACTION: "+soapAction);
			
			if (rpc_type) {
				
				//payload is an XML soap message, need to parse out the stuff to locate it (soapAction/opns:op)
				
				Document doc = XMLUtil.documentFromString(payload);
				
				//store message under soap action only (in case it's document encoded)
				//store message under soap action / operation qname (in case it's RPC encoded)
				//NOTE: messages must be stored unmodified (unstripped of the SOAP wrapper) because
				//it is not possible at this time to tell whether it is Document or RPC encoded
	
				ArrayList namespaces = new ArrayList();
				
				Element envelope_elem = doc.getDocumentElement();
				Element body_elem = null;
				Element opname_elem = null;
				
				SOAPUtils.gatherNamespaces(namespaces,envelope_elem);
	
				NodeList bodies = envelope_elem.getChildNodes();
				int b = 0;
				while (body_elem == null) {
					Node body = bodies.item(b++);
					if (body.getNodeType() == Node.ELEMENT_NODE) {
						body_elem = (Element)body;
	
						SOAPUtils.gatherNamespaces(namespaces,body_elem);
						
						NodeList opnames = body_elem.getChildNodes();
						int p = 0;
						while (opname_elem == null) {
							Node opname = opnames.item(p++);
							if (opname.getNodeType() == Node.ELEMENT_NODE) {
								
								opname_elem = (Element)opname;
								
								SOAPUtils.gatherNamespaces(namespaces,opname_elem);
							}
						}
					}
				}
				
				String tagname = opname_elem.getTagName();
				operation = NamespaceTranslator.getName(tagname);
				operationNamespace = "";
				String opns = "";
				if (operation.length() != tagname.length()) {
					opns = tagname.substring(0,(tagname.length()-operation.length())-1);
				}
				
				for (int i = 0; i < namespaces.size(); i++) {
					Attr attr = (Attr)namespaces.get(i);
					String name = attr.getName();
					String value = attr.getValue();
					
					if (name.startsWith("xmlns")) {
						
						String nsname = "";
						
						if (!name.equals("xmlns")) {
							nsname = NamespaceTranslator.getName(name);
						}
						
						if (nsname.equals(opns)) {
							//match!
							operationNamespace = value;
						}
					}
				}
				if (SOAPFactory.DEBUG) System.out.println("OPERATION NAMESPACE: "+operationNamespace);
				if (SOAPFactory.DEBUG) System.out.println("OPERATION: "+operation);
				
			}
			
			return new HTTPResponse(listener.doRequest(port,rpc_type,operationNamespace,operation,soapAction,payload));
			
		} catch (SOAPNotFoundException e) {
			throw new HTTPNotFoundException(e.toString());
		} catch (Exception e) {
			throw new HTTPException("\n-----\n"+SOAPUtils.getStackTrace(e)+"\n-----\n");
		}
	}
}