/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.mainengine;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.stp.b2j.core.jengine.internal.Version;
import org.eclipse.stp.b2j.core.jengine.internal.api.Program;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Switches;
import org.eclipse.stp.b2j.core.jengine.internal.core.PrintHandler;
import org.eclipse.stp.b2j.core.jengine.internal.core.Runner;
import org.eclipse.stp.b2j.core.jengine.internal.core.SubControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageReader;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageWriter;
import org.eclipse.stp.b2j.core.jengine.internal.message.TransactionListener;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerInputStream;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerOutputStream;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.Session;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.SessionFactory;
import org.eclipse.stp.b2j.core.jengine.internal.utils.ClassPathHacker;
import org.eclipse.stp.b2j.core.jengine.internal.utils.DataTransfer;
import org.eclipse.stp.b2j.core.jengine.internal.utils.GCThread;
import org.eclipse.stp.b2j.core.jengine.internal.utils.ID;
import org.eclipse.stp.b2j.core.jengine.internal.utils.LineBasedPrintStream;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.misc.internal.HexData;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

/**
 * 
 * @author amiguel
 *
 * The distributed engine main SubController implementation, see the plugin architecture docs for more info.
 */
public class SubController extends ControllerConnection implements SubControllerInterface, Runnable, TransactionListener {

public static final String[] SUBCONTROLLER_SOCKET_IDS = new String[]{"SubController:minor->major transaction",
																	"SubController:minor<-major transaction",
																	"SubController:minor<->major notifications"};

private static final int CLIENT_CONTROLLER = 0;

public static final int SUBCONTROLLER_UNRECOGNISED_MESSAGE = -1;

public static final int SUBCONTROLLER_EMPTY = -2;

//IN
public static final int SUBCONTROLLER_LAUNCH_RUNNER = 10;
//int - runner count
//String - method name
//...(these could be the args to the runner?)
	//OUT
	public static final int SUBCONTROLLER_LAUNCH_RUNNER_OK = 11;
	//OUT
	public static final int SUBCONTROLLER_LAUNCH_RUNNER_FAIL = 12;
	//String - error message

//IN
public static final int SUBCONTROLLER_SET_PROGRAM = 100;
//byte[] - program (class file)
	//OUT
	public static final int SUBCONTROLLER_SET_PROGRAM_OK = 101;
	//OUT
	public static final int SUBCONTROLLER_SET_PROGRAM_FAIL = 102;
	//String - error message


//IN
public static final int SUBCONTROLLER_SIGNAL_RUNNER = 200;
//long rid
	//OUT
	public static final int SUBCONTROLLER_SIGNAL_RUNNER_OK = 201;
	//OUT
	public static final int SUBCONTROLLER_SIGNAL_RUNNER_FAIL = 202;
	//String - error message

//IN
public static final int SUBCONTROLLER_MAKE_VARIABLE = 300;
	//OUT
	public static final int SUBCONTROLLER_MAKE_VARIABLE_OK = 301;
	//OUT
	public static final int SUBCONTROLLER_MAKE_VARIABLE_FAIL = 302;
	//String - error message

//IN
public static final int SUBCONTROLLER_NOTIFY_DIRTY = 400;
	//OUT
	public static final int SUBCONTROLLER_NOTIFY_DIRTY_OK = 401;
	//OUT
	public static final int SUBCONTROLLER_NOTIFY_DIRTY_FAIL = 402;
	//String - error message

//IN
public static final int SUBCONTROLLER_SYNC_CLOCK = 500;
//long - offset
	//OUT
	public static final int SUBCONTROLLER_SYNC_CLOCK_OK = 501;
	//OUT
	public static final int SUBCONTROLLER_SYNC_CLOCK_FAIL = 502;
	//String - error message

//	IN
public static final int SUBCONTROLLER_WAKE_RUNNER = 600;
//long id
	  //OUT
	  public static final int SUBCONTROLLER_WAKE_RUNNER_OK = 601;
	  //OUT
	  public static final int SUBCONTROLLER_WAKE_RUNNER_FAIL = 602;
	  //String - error message

//	IN
public static final int SUBCONTROLLER_RECEIVE_MESSAGE = 700;
//long id
//Message data
	  //OUT
	  public static final int SUBCONTROLLER_RECEIVE_MESSAGE_OK = 701;
	  //OUT
	  public static final int SUBCONTROLLER_RECEIVE_MESSAGE_FAIL = 702;
	  //String - error message

//	IN 
public static final int SUBCONTROLLER_RUNNER_STACKDUMP = 800;

//	IN
public static final int SUBCONTROLLER_SET_CLIENTHOST = 900;
//String host
	  //OUT
	  public static final int SUBCONTROLLER_SET_CLIENTHOST_OK = 901;
	  //OUT
	  public static final int SUBCONTROLLER_SET_CLIENTHOST_FAIL = 902;
	  //String - error message

//	IN
public static final int SUBCONTROLLER_SET_LOG_LEVEL = 1000;
//boolean - error
//boolean - warning
//boolean - info
	  	  //OUT
	  	  public static final int SUBCONTROLLER_SET_LOG_LEVEL_OK = 1001;
	  	  //OUT
	  	  public static final int SUBCONTROLLER_SET_LOG_LEVEL_FAIL = 1002;
	  	  //String - error message

//IN 
public static final int SUBCONTROLLER_RUNNER_STACKTRACE = 1100;
//int - trace message id

public static final int SUBCONTROLLER_CHECK_DEPS_CACHE = 1200;
	  	  //OUT
	  	  public static final int SUBCONTROLLER_CHECK_DEPS_CACHE_OK = 1201;
	  	  //OUT
	  	  public static final int SUBCONTROLLER_CHECK_DEPS_CACHE_FAIL = 1202;


private static final Object LOCK_SERVER = new Object();

boolean PRINT_INFO = true;
boolean PRINT_DEBUG = true;

long clock = 0;

//int id;
//String host;
//int port;

OutputStream stdout = new BufferedOutputStream(new PrintMessageStream());

Session session;
//ServerSocket server;
RunnerThreadGroup runner_group = new RunnerThreadGroup();
private int RUNNERS_ID = 1;
private List activeRunners = Collections.synchronizedList(new LinkedList());
Program program;
byte[] programb;
Class program_class;

//ArrayList shared_vars = new ArrayList();
//ArrayList shared_sems = new ArrayList();
//HashMap shared_vars_map = new HashMap();
//HashMap shared_sems_map = new HashMap();

//if one of these dies then the controller shuts down
//at the moment, only non-client threads are critical
CriticalThreadGroup ctg = new CriticalThreadGroup();
NonCriticalThreadGroup nctg = new NonCriticalThreadGroup();


Object notify_LOCK = new Object();
MessageReader notify_in;
MessageWriter notify_out;

SessionAddress actual_address;

String client_host;

private static boolean redirected = false;
	
	private static void redirectStdout() {
		redirected = true;
		System.setOut(System.err);
	}
	
	private static void restoreStdout() {
		restoreStdout(null);
	}
	private static void restoreStdout(String s) {
		if (redirected) {
			redirected = false;
			PrintStream pout = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out),128));
			pout.println(s);
			System.setOut(pout);
		}
	}

	ZombieThread zt;
	
	public static void main(String[] args) {
		redirectStdout();

		if (Switches.CONSTANT_GARBAGE_COLLECTION) {
			GCThread.startThread();
		}

		SessionAddress address;
//		int start_port;
		int id;
//		String host;
		
		if (args.length < 1) {
			restoreStdout();
			System.out.println("Too few arguments");
			return;	
		}
		
		try {
			id = Integer.parseInt(args[0]);			
		} catch (Exception e) {
			restoreStdout();
			System.out.println("Invalid id");
			return;
		}

		try {
			BufferedReader bread = new BufferedReader(new InputStreamReader(System.in));
			String req_address = HexData.hexStringToString(bread.readLine().trim());

			address = SessionAddress.fromString(req_address);
//			address = SessionAddress.fromString(HexData.hexStringToString(args[0]));
//			start_port = Integer.parseInt(args[0]);			
		} catch (Exception e) {
			restoreStdout();
			System.out.println("Invalid session address");
			return;
		}

		
//		host = args[2];			

		try {
//			SubController subc = new SubController(start_port,id,host);
			SubController subc = new SubController(address,id,true);
		} catch (Exception e) {
			restoreStdout();
			e.printStackTrace();	
		}
		
	}

//	public SubController(int start_port, int id, String host) throws Exception {
	public SubController(SessionAddress session_address, int id) throws Exception {
		this(session_address,id,false);
	}
	public SubController(SessionAddress session_address, int id, boolean couldZombie) throws Exception {
		super(id);
		
		if (couldZombie) {
			zt = new ZombieThread(1000l * 60l * 60l);//one hour
		}
		
//		this.port = start_port;
		this.id = id;
//		this.host = host;

//		while (port < 65536) {
			
			try {
//				session_address = new SessionAddress("localhost",SessionAddress.TRANSPORT_PORT_ANY,SessionAddress.TRANSPORT_PORT_ANY,"localhost",start_port,SessionAddress.TRANSPORT_PORT_ANY);
				session = SessionFactory.newSession(session_address,false);

				session.beginNonBlocking();
				session.waitUntilSessionTransportBound();

				actual_address = session.getActualAddress();
								
				restoreStdout(HexData.stringToHexString(SessionAddress.toString(session.getActualAddress())));
				System.out.flush();
				
//				this.port = session.getActualAddress().listener_port_min;
				
//				server = new ServerSocket(port);
//				System.out.println(port);

//				System.setOut(new PrintStream(stdout));
//				System.setErr(new PrintStream(stdout));
//				System.setErr(stdout);

				Thread th = new Thread(this);
				th.setName("JEngine SubController [Controller Server Init] Thread (ID: "+id+") ("+actual_address+")");
				th.start();
				
//				break;
			} catch (IOException e) {
//				if (port == 65535) throw new Exception("No free ports!");
//				port++;
			}
//		}

		System.gc();
	} 
	
	public SessionAddress getAddress() {
		return actual_address;
	}
	
//	public int getPort() {
//		return port;	
//	}

	public long getClock() {
		return System.currentTimeMillis()-clock;	
	}

	public void run() {
		Thread th = Thread.currentThread();
		
		try {
//			Socket sock = SocketSetup.getServer(server,SUBCONTROLLER_SOCKET_IDS);
			session.waitUntilSessionTransportReady();
			
//			Logger.direct("new SubController on "+sock.getLocalPort());
			Logger.direct("new SubController (version "+Version.getVersionAsString()+") on "+session.getActualAddress());
			
			short s_server = 0;
			short s_client = 1;
			short s_notify = 2;

//			MultiplexerInputStream mxin = new MultiplexerInputStream(sock.getInputStream());
//			MultiplexerOutputStream mxout = new MultiplexerOutputStream(sock.getOutputStream());
			MultiplexerInputStream mxin = new MultiplexerInputStream(session.getInputStream(Session.DEFAULT_STREAM_INDEX));
			MultiplexerOutputStream mxout = new MultiplexerOutputStream(session.getOutputStream(Session.DEFAULT_STREAM_INDEX));
							
//			// we dont want Nagle's algorithm slowing down our transactions here
//			sock.setTcpNoDelay(true);

			ts = TransactionFactory.getTransactionServer(mxin.getInputStream(s_server),mxout.getOutputStream(s_server),this,ctg,"JEngine SubController [Controller Client Reader] Thread (ID: "+id+") ("+actual_address+")");
			tc = TransactionFactory.getTransactionClient(mxin.getInputStream(s_client),mxout.getOutputStream(s_client),ctg,"JEngine SubController [Controller Server] Thread (ID: "+id+") ("+actual_address+")");

			notify_in = new MessageReader(mxin.getInputStream(s_notify),ctg,"JEngine SubController [Controller Notify Reader] Thread (ID: "+id+") ("+actual_address+")");
			notify_out = new MessageWriter(mxout.getOutputStream(s_notify));

		} catch (Throwable t) {
			Logger.error("error while setting up connection");
		}
	}
	
	private void setProgram(byte[] programb, Message dependencies) throws Exception {
		if (zt != null) {
			zt.dontDie();
		}
		
		this.programb = programb;
		this.program = Program.readProgram(programb);
		
		Controller.storeNewJarsToCache(dependencies);
		
		if (program.getPrintStdouterr()) {
			Logger.direct("Redirecting stdout to engine messaging");
			
			System.setOut(new PrintStream(new LineBasedPrintStream() {
				public void doSomethingWith(String s) {
					try {
						print(s);
					} catch (Exception e) {
						Logger.warning(s);
					}
				}
			}));
			
			System.setErr(new PrintStream(new LineBasedPrintStream() {
				public void doSomethingWith(String s) {
					try {
						print(s);
					} catch (Exception e) {
						Logger.warning(s);
					}
				}
			}));
		}
		PRINT_INFO = program.getPrintInfo();
		PRINT_DEBUG = program.getPrintDebug();
		
		URL[] dep_urls = new URL[dependencies.length()];
		for (int i = 0; i < dep_urls.length; i++) {
			
			JARDependency orig;
			
			if (dependencies.getType(i) == Message.TYPE_SUBMESSAGE) {
				orig = JARDependency.fromMessage((Message)dependencies.get(i));
			} else {
				String cachekey = (String)dependencies.get(i);
				
				String path = Controller.DEPS_CACHE_DIR+"/"+cachekey;
				
				byte[] dat;
				FileInputStream fin = new FileInputStream(path);
				dat = StreamUtils.readAll(fin);
				fin.close();
				orig = new JARDependency(dat,path);
			}

			Logger.direct("dependency "+i+" of "+dep_urls.length);
			
			Logger.direct("processing dependency "+orig.getFileName()+" ("+orig.getJarData().length+" bytes)");
			JARDependency local = JARDependency.writeTemporaryDependency(orig);

			Logger.direct("processed dependency "+local.getFileName()+", stored to "+local.getFilePath());
//			dep_urls[i] = new File(orig.getFilePath()).toURL();
			dep_urls[i] = new File(local.getFilePath()).toURL();

			try {
				ClassPathHacker.addFile(new File(local.getFilePath()));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		
		this.program_class = program.getProgramClass(dep_urls,SubController.class.getClassLoader());

	}

//	private Object[] launchRunner(int count, String method, ArrayList args) throws Exception {
	private Object[] launchRunner(int count, String method, Message args) throws Exception {
		Message launched = new Message();
		ArrayList rthreads = new ArrayList();
		
		for (int i = 0; i < count; i++) {

			long rid = ID.CREATE_ID(id,RUNNERS_ID++);
			String rid_hex = ID.ID_HEX(rid);

			Object program_object = program_class.newInstance();

			Field runner_id = program_class.getDeclaredField("runner_id");
			runner_id.setAccessible(true); //just in case
			runner_id.setLong(program_object,rid);

			Field runner_args = program_class.getDeclaredField("runner_args");
			runner_args.setAccessible(true); //just in case
			runner_args.set(program_object,args);

//			Field runner_id_hex = program_class.getDeclaredField("runner_id_hex");
//			runner_id_hex.setAccessible(true); //just in case
//			runner_id_hex.set(program_object,rid_hex);

//			Field connector = program_class.getDeclaredField("connector");
//			connector.setAccessible(true); //just in case
//			connector.set(program_object,Connector.getConnector());

			Runner r = new Runner(runner_group,"JEngine Runner Thread (ID: "+ID.ID_HEX(rid)+")",this,rid,program_class,program_object,method);
			activeRunners.add(r);
/*			
			synchronized(wait_directory_LOCK) {
				RunnerLock rlock = new RunnerLock();
				wait_directory.put(new Long(rid),rlock);
			}
*/			
			r.start();
			
			//add this runners ID to the launched list
			launched.append(rid);
			rthreads.add(r);
		}
		return new Object[]{launched,rthreads};
	}

	/////////////////////////////////////////////////////
	// RUNNER interface methods
	/////////////////////////////////////////////////////

	public ArrayList launchRunnerLocal(int count, String method, ArrayList args) throws Exception {
		Message margs = new Message();
		for (int i = 0; i < args.size(); i++) {
			margs.append((String)args.get(i));
		}
		return launchRunnerLocal(count,method,margs);
	}
	public ArrayList launchRunnerLocal(int count, String method, Message args) throws Exception {
		return (ArrayList)launchRunner(count,method,args)[1];
	}

	public String getHost() throws Exception {
		return actual_address.getListenerHost();
	}
	public String getClientHost() throws Exception {
		return client_host;
	}
/*
	public void runnerStackDump() {
		//overridden in SubController because notifications are more likely to get through
		try {
			Message m = new Message(Controller.CONTROLLER_RUNNER_STACKDUMP);

			if (Switches.MESSAGES_WITH_CALLSTACK) {
				m.appendToCallStack(new Throwable("Message Callstack - Trace"));
			}

			synchronized(notify_LOCK) {
				notify_out.write(m);
			}		
		} catch (Throwable t) {
			Logger.direct("Runner stackdump failed - "+t);
		}
	}*/
	
	public void trace(Message m) throws Exception {
		Message trace = new Message(Controller.CONTROLLER_TRACE);
		trace.append(m);
		
		if (Switches.MESSAGES_WITH_CALLSTACK) {
			trace.appendToCallStack(new Throwable("Message Callstack - Trace"));
		}

		synchronized(notify_LOCK) {
			notify_out.write(trace);
		}		
	}

	public void print(String s) throws Exception {
		if (!PRINT_INFO) return;
		
		if (ph != null) {
			ph.print(s);
		} else {
			Message m = new Message(Controller.CONTROLLER_PRINT);
			m.append(s);

			if (Switches.MESSAGES_WITH_CALLSTACK) {
				m.appendToCallStack(new Throwable("Message Callstack - Print"));
			}

			synchronized(notify_LOCK) {
				notify_out.write(m);
			}		
		}
	}

	public void debug(String s) throws Exception {
		if (!PRINT_DEBUG) return;

		if (ph != null) {
			ph.debug(s);
		} else {
			Message m = new Message(Controller.CONTROLLER_DEBUG);
			m.append(s);
	
			if (Switches.MESSAGES_WITH_CALLSTACK) {
				m.appendToCallStack(new Throwable("Message Callstack - Debug"));
			}
	
			synchronized(notify_LOCK) {
				notify_out.write(m);
			}		
		}
	}
	
	public void trace(Object[] al) throws Exception {
		Message m = new Message(Controller.CONTROLLER_TRACE);
		m.append(DataTransfer.serialise(al));

		if (Switches.MESSAGES_WITH_CALLSTACK) {
			m.appendToCallStack(new Throwable("Message Callstack - Trace Objects"));
		}
		
		synchronized(notify_LOCK) {
			notify_out.write(m);
		}		
	}

	public void notifyRunnerDeath(long id, Runner runner) throws Exception {
		activeRunners.remove(runner);
		
		Message m = new Message(Controller.CONTROLLER_RUNNER_DEATH);
		m.append(id);
		
		if (Switches.MESSAGES_WITH_CALLSTACK) {
			m.appendToCallStack(new Throwable("Message Callstack - Notify Runner Death"));
		}
		
		synchronized(notify_LOCK) {
			notify_out.write(m);
		}		
	}
	
	/////////////////////////////////////////////////////
	// (END) RUNNER interface methods
	/////////////////////////////////////////////////////

	public Message doTransaction(Message m) {
//		synchronized(LOCK_SERVER) {
		Message r;
		int type = m.getType();

		if (type == SUBCONTROLLER_EMPTY) {
			r = m;
		
		} else if (type == SUBCONTROLLER_SYNC_CLOCK) {
//simulate a dodgy network
//try {
//Thread.sleep(100 + (long)(Math.random() * 100));
//} catch (Exception e) {}			
			clock = System.currentTimeMillis();
			Long offset = (Long)m.get(0);
			clock -= offset.longValue();
			
//			Logger.info("SUBCONTROLLER CLOCK - "+clock);

			r = new Message(SUBCONTROLLER_SYNC_CLOCK_OK);
//simulate a dodgy network
//try {
//Thread.sleep(100 + (long)(Math.random() * 100));
//} catch (Exception e) {}			
					
		} else if (type == SUBCONTROLLER_SET_PROGRAM) {
			Logger.info("SUBCONTROLLER: Set program");

			try {
				setProgram((byte[]) m.get(0), (Message)m.get(1));
				r = new Message(SUBCONTROLLER_SET_PROGRAM_OK);
			} catch (Exception e) {
				r = new Message(SUBCONTROLLER_SET_PROGRAM_FAIL);	
				r.append(Logger.getStackTrace(e));	
			}

		} else if (type == SUBCONTROLLER_CHECK_DEPS_CACHE) {
			Logger.info("SUBCONTROLLER: Check JAR Dependencies Cache");
			
			r = Controller.checkDependenciesCache(m);
			r.setType(SUBCONTROLLER_CHECK_DEPS_CACHE_OK);
			
		} else if (type == SUBCONTROLLER_LAUNCH_RUNNER) {
			Logger.info("SUBCONTROLLER: Launch Runner");

			Integer count = (Integer)m.get(0);
			String method = (String)m.get(1);

			Message args = new Message();
			if (m.length() > 2) {
				args.appendAll((Message)m.get(2));
			}
//			ArrayList args = new ArrayList();
//			for (int a = 2; a < m.length(); a++) {
//				args.add((String)m.get(a));
//			}

			try {
				Message launched = (Message)launchRunner(count.intValue(),method,args)[0];
				r = new Message(SUBCONTROLLER_LAUNCH_RUNNER_OK);
//				r.appendAll(launched);
				r.append(launched);
			} catch (Exception e) {
				r = new Message(SUBCONTROLLER_SET_PROGRAM_FAIL);
				r.append(Logger.getStackTrace(e));	
			}

		} else if (type == SUBCONTROLLER_RUNNER_STACKTRACE) {
			Logger.direct("SUBCONTROLLER STACK TRACE");
			
			Integer trace_msg_id = (Integer)m.get(0);
			
			try {
				for (int i = 0; i < activeRunners.size(); i++) {
					Runner runner = (Runner)activeRunners.get(i);
					Message stackmsg = runner.getStackContents();
					stackmsg.setType(trace_msg_id.intValue());
					
					trace(stackmsg);
				}
			} catch (Throwable t) {
				Logger.error("Error generating stacktrace",t);
			}
			
			r = new Message(SUBCONTROLLER_RUNNER_STACKTRACE);
			
		} else if (type == SUBCONTROLLER_RUNNER_STACKDUMP) {
			Logger.direct("SUBCONTROLLER STACK DUMP");
			
			try {
				for (int i = 0; i < activeRunners.size(); i++) {
					StringBuffer sb = new StringBuffer("SubController "+getHost()+" - Runner Stack Dump:\n");
					Runner runner = (Runner)activeRunners.get(i);
					String tmp = runner.getStack();
					Logger.direct(tmp);
					sb.append(tmp);

					print(sb.toString());
				}
			} catch (Throwable t) {
				Logger.error("Error tracing stackdump",t);
			}
			
			
			r = new Message(SUBCONTROLLER_RUNNER_STACKDUMP);
			
		} else if (type == SUBCONTROLLER_SET_CLIENTHOST) {
			Logger.direct("SUBCONTROLLER SET CLIENT HOST");
			
			try {
				client_host = (String)m.get(0);
				r = new Message(SUBCONTROLLER_SET_CLIENTHOST_OK);
			} catch (Throwable t) {
				r = new Message(SUBCONTROLLER_SET_CLIENTHOST_FAIL);
				r.append(Logger.getStackTrace(t));
			}
			
		} else {
			r = super.doTransaction(m);				
		}
		
		return r;
//		}//end synch
	}
	
////////////////////////////////////////////////
// INNER CLASSES
////////////////////////////////////////////////
	class RunnerThreadGroup extends ThreadGroup {
		public RunnerThreadGroup() {
			super("Runner Thread Group");	
		}	
		public void uncaughtException(Thread t, Throwable e) {
			//not sure what to do here  
			e.printStackTrace();
			
			//exit if an unexpected error occurs, otherwise we hang :(
			System.exit(0);
		}
	}

	class PrintMessageStream extends OutputStream {
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		
		public void write(int i) {
			bout.write((byte)(i&0xFF));	
		}
		
		public void write(byte[] b) {
			for (int i = 0; i < b.length; i++) {
				bout.write(b[i]);
				if (b[i] == '\n') flush();
			}
//			bout.write(b,0,b.length);	
		}
		public void write(byte[] b, int off, int len) {
			for (int i = off; i < len; i++) {
				bout.write(b[i]);
				if (b[i] == '\n') flush();
			}
//			bout.write(b,off,len);	
		}  
		public void flush() {
			synchronized(bout) {
				try {
					print(new String(bout.toByteArray()));
				} catch (Exception e) {
				}
				bout.reset();
			}
		}		
	}

	PrintHandler ph;
	public void setPrintHandler(PrintHandler ph) throws Exception {
		this.ph = ph;
	}

}

