/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.mainengine;

import java.io.InputStream;
import java.io.OutputStream;

import org.eclipse.stp.b2j.core.jengine.internal.message.BPlaneTransactionClient;
import org.eclipse.stp.b2j.core.jengine.internal.message.BPlaneTransactionServer;
import org.eclipse.stp.b2j.core.jengine.internal.message.MTTransactionClient;
import org.eclipse.stp.b2j.core.jengine.internal.message.MTTransactionServer;
import org.eclipse.stp.b2j.core.jengine.internal.message.TransactionListener;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;

/**
 * 
 * @author amiguel
 * 
 * This is not a factory to create Daemons but a factory created by the
 * Daemon class based on setup information from the config file
 */
public class TransactionFactory {
	
	public static MTTransactionClient getTransactionClient(InputStream in,
														OutputStream out,
														ThreadGroup tg,
														String thread_name
														) {
//x		if (Daemon.USE_MT_QUEUES) {
//x			Logger.info("Returning MT QUEUE");
//x			return new QueueMTTransactionClient(in,out,tg,thread_name);	
//x		} else {

//			Logger.info("Returning MT BASIC");
//			return new BasicMTTransactionClient(in,out,tg,thread_name);	
			
			Logger.info("Returning MT Client with Buffer Planes");
			return new BPlaneTransactionClient(in,out,tg,thread_name);
			
//x		}
	}

	public static MTTransactionServer getTransactionServer(InputStream in,
														OutputStream out,
														TransactionListener tl,
														ThreadGroup tg,
														String thread_name
														) {
//x		if (Daemon.USE_MT_QUEUES) {
//x			Logger.info("Returning MT QUEUE");
//x			return new QueueMTTransactionClient(in,out,tg,thread_name);	
//x		} else {

//			Logger.info("Returning MT BASIC");
//			return new BasicSTTransactionServer(in,out,tl,tg,thread_name);
	
			Logger.info("Returning MT Server with Buffer Planes");
			return new BPlaneTransactionServer(in,out,tl,tg,thread_name);
				
//x		}
	}
}