package org.eclipse.stp.b2j.core.jengine.internal.mainengine;

public class ZombieThread extends Thread {

	Object LOCK = new Object();
	
	boolean OK;
	long crunchTime;
	
	public ZombieThread(long waitThenDie) {
		crunchTime = System.currentTimeMillis()+waitThenDie;
		OK = false;
		start();
	}
	
	public void dontDie() {
		synchronized(LOCK) {
			OK = true;
		}
	}
	
	public void run() {
		while (true) {
			
			try {
				Thread.sleep(5000);
			} catch (Exception e) {}
			
			synchronized(LOCK) {
				if (OK) {
					return;
				} else if (System.currentTimeMillis() > crunchTime) {
					System.exit(77);
				}
			}
		}
	}
	
	public static void main(String[] args) throws Exception {
		
		{
			ZombieThread zt = new ZombieThread(10000);
			zt.dontDie();
			Thread.sleep(15000);
			
			System.out.println("NOT dying works");
		}
		
		{
			ZombieThread zt = new ZombieThread(10000);
			Thread.sleep(15000);
			
			System.out.println("Dying DOES NOT work");
		}
		
	}
}