/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import org.eclipse.stp.b2j.core.jengine.internal.core.api.TraceListener;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.publicapi.engine.BPELEngineListener;

public class EngineListenerTraceListener implements TraceListener {

	BPELEngineListener engine;
	
	public EngineListenerTraceListener(BPELEngineListener engine) {
		this.engine = engine;
	}
	
	public void trace(Message m) {
		//do nothing
	}

	public void print(String s) {
		engine.printEngineInfo(s);
	}

	public void debug(String s) {
		engine.printEngineDebug(s);
	}
	
	
}