/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.stp.b2j.core.ui.internal.debug;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.stp.b2j.core.jengine.internal.debug.DebugConstants;

/**
 * @author amiguel
 */
public class DebugLineBreakpoint extends LineBreakpoint {

	public DebugLineBreakpoint(IResource resource, int lineNumber) throws CoreException {
//		IMarker marker = resource.createMarker("org.eclipse.debug.examples.core.pda.lineBreakpoint.marker");
		IMarker marker = resource.createMarker("org.eclipse.stp.b2j.core.jengine.internal.debug.lineBreakpoint.marker");
		setMarker(marker);
		setEnabled(true);
		ensureMarker().setAttribute(IMarker.LINE_NUMBER, lineNumber);
		ensureMarker().setAttribute(IBreakpoint.ID, DebugConstants.DEBUG_MODEL_ID);
	}
	
	public String getModelIdentifier() {
		return DebugConstants.DEBUG_MODEL_ID;
	}
	
}