/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation.specification;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.validation.BpmnValidationMessages;

public class SequenceEdgeConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        if (ctx.getTarget() instanceof SequenceEdge && (ctx.getFeature() == null || ctx.getFeature().getFeatureID() == 14)) {
            SequenceEdge edge = (SequenceEdge)ctx.getTarget();
            Vertex source = edge.getSource();
            Vertex target = edge.getTarget();
            if (source == null || target == null) {
                return ctx.createSuccessStatus();
            }
            if (source instanceof Activity) {
                switch (((Activity)source).getActivityType().getValue()) {
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: {
                        return ctx.createFailureStatus(new Object[]{BpmnValidationMessages.SequenceEdgeConstraint_endEventStartOfEdge});
                    }
                }
            }
            if (target instanceof Activity) {
                switch (((Activity)target).getActivityType().getValue()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return ctx.createFailureStatus(new Object[]{BpmnValidationMessages.SequenceEdgeConstraint_StartEventEndOfEdge});
                    }
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

