/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/

/**
 * Date             Author              Changes
 * Jul 14, 2006     hmalphettes         Created
 **/

package org.eclipse.stp.bpmn.commands;

import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;

/**
 * Sets an extra hint on the IElementType. This is custom code, not generated by
 * GMF/EMF.
 * 
 * We use the secondary hint to hold the value of the activity type that we need
 * to create. This way, even though we have a single class for all activities we
 * can still have a different tool for each one of them.
 * 
 * Once the ElementTypeFactory is modified to work with this type of ElementType
 * it integrates with the rest of the GMF runtime.
 * 
 * @see IElementType
 * 
 * @author hmalphettes
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public interface IElementTypeEx extends IHintedType {

    /**
     * @return a semantic hint that lives outside of the extensible element
     *         types registry.
     */
    public String getSecondarySemanticHint();
}
