/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.infrastructure.emf;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class ResourceUtilities {
    private static final IWorkspaceRoot WORKSPACE_ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private static final String PLATFORM_RESOURCE = "resource";
    public static final String PLATFORM_PROTOCOL = "platform";

    public static IFile getPlatformFile(URI uri) {
        if (ResourceUtilities.isPlatformResourceURI(uri)) {
            String fileString = URI.decode((String)uri.path());
            Path filePath = new Path(fileString = fileString.substring(PLATFORM_RESOURCE.length() + 1));
            IResource resource = WORKSPACE_ROOT.findMember((IPath)filePath);
            if (resource == null) {
                return WORKSPACE_ROOT.getFile((IPath)filePath);
            }
            if (resource.getType() == 1) {
                return (IFile)resource;
            }
        }
        return null;
    }

    public static boolean isFile(URI uri) {
        if (ResourceUtilities.isPlatformResourceURI(uri)) {
            String fileString = URI.decode((String)uri.path());
            IResource resource = WORKSPACE_ROOT.findMember((IPath)new Path(fileString = fileString.substring(PLATFORM_RESOURCE.length() + 1)));
            if (resource == null || resource.getType() == 1) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPlatformResourceURI(URI uri) {
        return PLATFORM_PROTOCOL.equals(uri.scheme()) && PLATFORM_RESOURCE.equals(uri.segment(0));
    }
}

