/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.introspection.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.stp.core.internal.introspection.query.IModelQuery;
import org.eclipse.stp.core.sca.SCAObject;

public class CombinedQuery
implements IModelQuery {
    private final Set children = new HashSet();
    private Map untouchedElements = null;
    private CombinedQuery parent;
    private int type = 1;

    public CombinedQuery() {
    }

    public CombinedQuery(int aType) {
        this.type = aType;
    }

    public void setParent(CombinedQuery newParent) {
        this.parent = newParent;
    }

    public int getType() {
        return this.type;
    }

    public void addChildQuery(IModelQuery moreSpecificQuery) {
        if (moreSpecificQuery != null) {
            this.children.add(moreSpecificQuery);
            ((CombinedQuery)moreSpecificQuery).setParent(this);
        }
    }

    public Set getChildren() {
        return Collections.unmodifiableSet(this.children);
    }

    public List matches(List theSearchSet) {
        if (theSearchSet.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        EObject currentObject = null;
        ArrayList<EObject> result = new ArrayList<EObject>();
        int i = 0;
        while (i < theSearchSet.size()) {
            currentObject = (EObject)theSearchSet.get(i);
            if (this.matches(currentObject)) {
                result.add(currentObject);
            }
            ++i;
        }
        if (result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    protected final boolean matchesChildren(EObject anObject) {
        IModelQuery childQuery2 = null;
        for (IModelQuery childQuery2 : this.children) {
            if (childQuery2.matches(anObject)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(EObject theObject) {
        return this.matchesChildren(theObject);
    }

    public boolean applyDelta(EObject anObject) {
        this.calculateUntouchedElements(anObject);
        return this.applyChildrenDelta(anObject);
    }

    public boolean applyChildrenDelta(EObject anObject) {
        IModelQuery childQuery2 = null;
        for (IModelQuery childQuery2 : this.children) {
            if (childQuery2.applyDelta(anObject)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer("");
        IModelQuery childQuery2 = null;
        for (IModelQuery childQuery2 : this.children) {
            toString.append(childQuery2.toString()).append("\n");
        }
        return toString.toString();
    }

    protected final Map getUntouchedElements(EObject anObject) {
        this.calculateUntouchedElements(anObject);
        return this.untouchedElements;
    }

    public void calculateUntouchedElements(EObject anObject) {
        if (this.untouchedElements == null) {
            this.untouchedElements = new HashMap();
            EList contents = anObject.eContents();
            EObject eObj = null;
            int i = 0;
            while (i < contents.size()) {
                ArrayList<EObject> list;
                eObj = (EObject)contents.get(i);
                EReference feature = eObj.eContainmentFeature();
                EStructuralFeature affiliation = ExtendedMetaData.INSTANCE.getAffiliation((EStructuralFeature)feature);
                if (affiliation != null) {
                    feature = affiliation;
                }
                if ((list = (ArrayList<EObject>)this.untouchedElements.get(feature.getName())) == null) {
                    list = new ArrayList<EObject>();
                    this.untouchedElements.put(feature.getName(), list);
                }
                list.add(eObj);
                ++i;
            }
        }
    }

    protected final List getUntouchedElements(EObject anObject, EStructuralFeature aFeature) {
        EStructuralFeature affiliation = ExtendedMetaData.INSTANCE.getAffiliation(aFeature);
        if (affiliation != null) {
            aFeature = affiliation;
        }
        return (List)this.getUntouchedElements(anObject).get(aFeature.getName());
    }

    protected final List getParentUntouchedElements(EObject anObject, EStructuralFeature aFeature) {
        if (this.parent != null) {
            return this.parent.getUntouchedElements(anObject, aFeature);
        }
        return Collections.EMPTY_LIST;
    }

    public void removeUntouched(SCAObject anObject, EStructuralFeature feature) {
        List untouched = this.getUntouchedElements(anObject.getEObject(), feature);
        if (untouched != null) {
            EObject eObj = null;
            int i = 0;
            while (i < untouched.size()) {
                eObj = (EObject)untouched.get(i);
                EcoreUtil.remove((EObject)eObj);
                ++i;
            }
        }
    }
}

