/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.WSDLPortType;

public class SOACoreUtils {
    public static final SOACoreUtils INSTANCE = new SOACoreUtils();

    private SOACoreUtils() {
    }

    public List getAllJavaInterfaces(List services) {
        if (services == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Interface> allJavaInterfaces = new ArrayList<Interface>();
        for (Service service : services) {
            Interface intf = service.getInterface();
            if (!(intf instanceof JavaInterface)) continue;
            allJavaInterfaces.add(intf);
        }
        return allJavaInterfaces;
    }

    public List getAllWSDLInterfaces(List services) {
        if (services == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Interface> allWSDLInterfaces = new ArrayList<Interface>();
        for (Service service : services) {
            Interface intf = service.getInterface();
            if (!(intf instanceof WSDLPortType)) continue;
            allWSDLInterfaces.add(intf);
        }
        return allWSDLInterfaces;
    }

    public List getAllJavaReferenceInterfaces(List references) {
        if (references == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Interface> allJavaReferenceInterfaces = new ArrayList<Interface>();
        for (Reference reference : references) {
            Interface intf = reference.getInterface();
            if (!(intf instanceof JavaInterface)) continue;
            allJavaReferenceInterfaces.add(intf);
        }
        return allJavaReferenceInterfaces;
    }

    public List getAllWSDLReferences(List references) {
        if (references == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Reference> allWSDLReferences = new ArrayList<Reference>();
        for (Reference reference : references) {
            Interface intf = reference.getInterface();
            if (!(intf instanceof WSDLPortType)) continue;
            allWSDLReferences.add(reference);
        }
        return allWSDLReferences;
    }

    public List getAllWSDLReferenceInterfaces(List references) {
        if (references == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Interface> allWSDLReferenceInterfaces = new ArrayList<Interface>();
        for (Reference reference : references) {
            Interface intf = reference.getInterface();
            if (!(intf instanceof WSDLPortType)) continue;
            allWSDLReferenceInterfaces.add(intf);
        }
        return allWSDLReferenceInterfaces;
    }

    public SCAObject getSCAObjectByName(String name, ComponentType componentType, Class type) {
        SCAObject scaObject = null;
        List candidates = null;
        if (type == Reference.class) {
            candidates = componentType.getReferences();
        } else if (type == Property.class) {
            candidates = componentType.getProperties();
        } else if (type == Service.class) {
            candidates = componentType.getServices();
        }
        int i = 0;
        while (i < candidates.size() && scaObject == null) {
            SCAObject candidate = (SCAObject)candidates.get(i);
            if (candidate.getName().equals(name)) {
                scaObject = candidate;
            }
            ++i;
        }
        return scaObject;
    }
}

