/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.create.operations;

import java.util.Set;
import org.apache.xerces.util.XMLChar;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.create.operations.ICompositeCreationDataModelProperties;
import org.eclipse.stp.core.create.operations.ModuleCreationOperation;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerDataModelProvider;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class ModuleCreationDataModelProvider
extends AbstractScribblerDataModelProvider
implements ICompositeCreationDataModelProperties {
    protected static final String URI_RESTRICTED_CHARACTERS = ":?#@!";

    public IDataModelOperation getDefaultOperation() {
        return new ModuleCreationOperation(this.model);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("ICompositeCreationDataModelProperties.NAME");
        propertyNames.add("ICompositeCreationDataModelProperties.CONTAINER");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("ICompositeCreationDataModelProperties.NAME")) {
            return this.model.getStringProperty("IAbstractScribblerDataModelProperties.PROJECT_NAME");
        }
        if (propertyName.equals("ICompositeCreationDataModelProperties.CONTAINER")) {
            return this.getProject();
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("ICompositeCreationDataModelProperties.CONTAINER")) {
            return this.validateContainer();
        }
        if (propertyName.equals("ICompositeCreationDataModelProperties.NAME")) {
            return this.validateName();
        }
        return super.validate(propertyName);
    }

    private IStatus validateContainer() {
        Object object = this.getProperty("ICompositeCreationDataModelProperties.CONTAINER");
        if (object == null || !(object instanceof IContainer)) {
            return STPCorePlugin.createErrorStatus(Messages.invalidObjectPassed_errorText, null);
        }
        if (!((IContainer)object).exists()) {
            return STPCorePlugin.createErrorStatus(Messages.containerNotExisting_errorText, null);
        }
        return OK_STATUS;
    }

    private IStatus validateName() {
        IStatus returnStatus = OK_STATUS;
        String name = this.getStringProperty("ICompositeCreationDataModelProperties.NAME");
        if (name == null || name.length() <= 0) {
            returnStatus = STPCorePlugin.createErrorStatus(Messages.nameBlank_errorText, null);
        }
        if (!returnStatus.isOK()) {
            return returnStatus;
        }
        returnStatus = this.validateNameForValidCharaters(name);
        if (!returnStatus.isOK()) {
            return returnStatus;
        }
        IContainer container = (IContainer)this.getProperty("ICompositeCreationDataModelProperties.CONTAINER");
        IFile file = container.getFile((IPath)new Path(String.valueOf(name) + '.' + "module"));
        if (file != null && file.exists()) {
            returnStatus = STPCorePlugin.createErrorStatus(NLS.bind((String)Messages.nameNotValid_errorText, (Object)name), null);
        }
        return returnStatus;
    }

    private IStatus validateNameForValidCharaters(String name) {
        if (!XMLChar.isValidNCName((String)name)) {
            return STPCorePlugin.createErrorStatus(NLS.bind((String)Messages.nameNotValid_errorText, (Object)name), null);
        }
        int i = 0;
        while (i < URI_RESTRICTED_CHARACTERS.length()) {
            if (name.indexOf(URI_RESTRICTED_CHARACTERS.charAt(i)) != -1) {
                return STPCorePlugin.createErrorStatus(NLS.bind((String)Messages.portionOfNameNotValid_errorText, (Object)name, (Object)String.valueOf(URI_RESTRICTED_CHARACTERS.charAt(i))), null);
            }
            ++i;
        }
        return Status.OK_STATUS;
    }
}

