/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.infrastructure.emf;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.stp.core.infrastructure.assertion.Assert;

public class EclipseResourceDescriptor implements IResourceDescriptor {

   private final IPath defaultPath;

   private IPath       localPath;

   private boolean     loadAsReadOnly;

   private String      scheme = "platform:/resource"; //$NON-NLS-1$

   public EclipseResourceDescriptor(IPath theDefaultPath,
         IPath workspaceRelativeLocalPath) {
      Assert.isNotNull(theDefaultPath);
      Assert.isLegal(theDefaultPath.segmentCount() > 0);
      localPath = workspaceRelativeLocalPath;
      defaultPath = theDefaultPath;
   }

   public String toString() {
      return "ResourceDescriptor[localPath=\"" + localPath + "\", defaultPath=\"" + defaultPath + "\"]."; //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$
   }

   public EclipseResourceDescriptor(IFile aFile) {
      Assert.isNotNull(aFile);
      localPath = aFile.getFullPath();
      defaultPath = aFile.getProjectRelativePath();
   }

   public EclipseResourceDescriptor(IFile aFile, String aRequestProtocol) {
      Assert.isNotNull(aFile);
      localPath = aFile.getFullPath();
      defaultPath = aFile.getProjectRelativePath();
      scheme = aRequestProtocol;
   }

   public boolean isLoadAsReadOnly() {
      return loadAsReadOnly;
   }

   public void setLoadAsReadOnly(boolean toLoadAsReadOnly) {
      loadAsReadOnly = toLoadAsReadOnly;
   }

   public IPath getLocalPath() {
      if (localPath == null)
         return getDefaultPath();
      return localPath;
   }

   public IPath getDefaultPath() {
      return defaultPath;
   }

   public boolean matches(IFile file) {
      return getLocalPath().equals(file.getFullPath());
   }

   public boolean equals(Object obj) {
      if (obj instanceof IResourceDescriptor) {
         IResourceDescriptor other = ((IResourceDescriptor) obj);
         if (getRequestProtocol() == null)
            return other.getRequestProtocol() == null
                  && getLocalPath().equals(other.getLocalPath());
         else if (getRequestProtocol().equals(other.getRequestProtocol()))
            return getLocalPath().equals(other.getLocalPath());
      }
      return false;
   }

   public int hashCode() {
      return getLocalPath().hashCode();
   }

   public String getRequestProtocol() {
      return scheme;
   }

}
