/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.infrastructure.emf;

import java.util.Collections;
import java.util.List;

public class EditModelEvent {
   // These are the event codes.

   // Used when the edit model is saved.
   public static final int SAVE                            = 1;

   // Used when the command stack becomes dirty.
   public static final int DIRTY                           = 2;

   // Used when the command stack becomes dirty.
   public static final int REVERT                          = 10;

   // Used when a referenced resource is removed from the ResourceSet.
   public static final int REMOVED_RESOURCE                = 3;

   // Used when a referenced resource is added to the ResourceSet.
   public static final int ADDED_RESOURCE                  = 4;

   // Used when the edit model is disposed
   public static final int PRE_DISPOSE                     = 5;

   // Used when a Resource is loaded or the first object
   // is added to the contents when created.
   public static final int LOADED_RESOURCE                 = 6;

   // Used when a Resource is unloaded.
   public static final int UNLOADED_RESOURCE               = 7;

   // Indicates that the list of known resources managed by the edit model is
   // about to change
   public static final int KNOWN_RESOURCES_ABOUT_TO_CHANGE = 8;

   // Indicates that the list of known resources managed by the edit model has
   // changed
   public static final int KNOWN_RESOURCES_CHANGED         = 9;

   private final int       eventCode;

   private final List      changedResources;

   /** 
    */
   public EditModelEvent(int anEventCode) {
      eventCode = anEventCode;
      changedResources = Collections.EMPTY_LIST;
   }

   /** 
    */
   public EditModelEvent(int anEventCode, List theChangedResources) {
      eventCode = anEventCode;
      changedResources = Collections.unmodifiableList(theChangedResources);
   }

   /**
    * 
    * @return java.util.List
    */
   public List getChangedResources() {
      return changedResources;
   }

   /**
    * 
    * @return int
    */
   public int getEventCode() {
      return eventCode;
   }

   public String toString() {
      StringBuffer buffer = new StringBuffer("EditModelEvent[type ="); //$NON-NLS-1$
      switch (getEventCode()) {
         // Used when the edit model is saved.
         case SAVE:
            buffer.append("save"); //$NON-NLS-1$
            break;
         // Used when the command stack becomes dirty.
         case DIRTY:
            buffer.append("dirty"); //$NON-NLS-1$
            break;
         case REVERT:
            buffer.append("revert"); //$NON-NLS-1$
            break;
         // Used when a referenced resource is removed from the ResourceSet.
         case REMOVED_RESOURCE:
            buffer.append("removed resource"); //$NON-NLS-1$
            break;
         // Used when a referenced resource is added to the ResourceSet.
         case ADDED_RESOURCE:
            buffer.append("added resource"); //$NON-NLS-1$
            break;
         // Used when the edit model is disposed
         case PRE_DISPOSE:
            buffer.append("pre-dispose"); //$NON-NLS-1$
            break;
         // Used when a Resource is loaded or the first object
         // is added to the contents when created.
         case LOADED_RESOURCE:
            buffer.append("loaded resource"); //$NON-NLS-1$
            break;
         // Used when a Resource is unloaded.
         case UNLOADED_RESOURCE:
            buffer.append("unloaded resource"); //$NON-NLS-1$
            break;
      }
      return buffer.append("]").toString(); //$NON-NLS-1$
   }
}
