/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.infrastructure.emf;

import org.eclipse.core.resources.IProject;
import org.eclipse.stp.core.internal.infrastructure.emfworkbench.EMFWorkbenchEditContextFactory;

/**
 * The IEMFWorkbenchContextFactory manages the creation and caching of
 * IEMFWorkbenchContext objects.
 * 
 * <p>
 * Clients should use {@link #getContext(IProject)} to acquire an
 * IEMFWorkbenchContext.
 * </p>
 * 
 * @see org.eclipse.stp.core.infrastructure.emf.IEMFWorkbenchContext
 */
public interface IEMFWorkbenchContextFactory {

   public static final IEMFWorkbenchContextFactory eINSTANCE = EMFWorkbenchEditContextFactory.sINSTANCE;

   /**
    * 
    * @param aProject
    *           A project which will be used as a key to locate the
    *           IEMFWorkbenchContext and as a container for resources that are
    *           requested using relative paths.
    * @return A created (or cached) IEMFWorkbenchContext for the given project
    */
   IEMFWorkbenchContext getContext(IProject aProject);

   /**
    * Every installed Resource Assistant Factory will be consulted for each
    * IEMFWorkbenchContext that is created. A factory should only create
    * IResourceAssistants for interesting projects.
    * 
    * @param aResourceAssistantFactory
    *           A hook into the creation process of IEMfWorkbenchContext
    *           instances
    */
   void installResourceAssistantFactory(
         IResourceAssistantFactory aResourceAssistantFactory);

   /**
    * 
    * @param aResourceAssistantFactory
    *           Remove the assistant from the creation process
    */
   void uninstallResourceAssistantFactory(
         IResourceAssistantFactory aResourceAssistantFactory);
}
