/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.create.operations;

import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;

public interface IReferenceCreationDataModelProperties extends
      IAbstractScribblerDataModelProperties {
   /**
    * [REQUIRED] Component who owns this reference/s.
    * 
    * Type = {@link org.eclipse.stp.core.sca.ComponentType}
    */
   public static final String COMPONENT_TYPE = "IReferenceCreationDataModelProperties.COMPONENT_TYPE"; //$NON-NLS-1$

   /**
    * [REQUIRED] Name of the reference to be created.
    * 
    * Type = {@link String}
    */
   public static final String NAME           = "IServiceCreationDataModelProperties.NAME";            //$NON-NLS-1$	

   /**
    * [REQUIRED] String property used to set within the Interface. This will
    * either be a fully qualified name of the java class for the JavaInterface
    * or QName of the porttype for WSDLPortType interface.
    * 
    * Type = {@link String}
    */
   public static final String INTERFACE      = "IServiceCreationDataModelProperties.INTERFACE";       //$NON-NLS-1$

   /**
    * [REQUIRED] Property to indicate if its a Java Interface or a WSDL
    * interface or other types.
    * 
    * Type = {@link JAVA_INTERFACE} or {@link WSDL_PORTYPE}
    */
   public static final String INTERFACE_TYPE = "IServiceCreationDataModelProperties.INTERFACE_TYPE";  //$NON-NLS-1$

   /**
    * [REQUIRED] multiplicity of reference.
    * 
    * Type = {@link String}
    */
   public static final String MULTIPLICITY   = "IReferenceCreationDataModelProperties.MULTIPLICITY";  //$NON-NLS-1$	
}
