/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.resources;

import org.eclipse.core.resources.IProject;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.DefaultScribblerDomain;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;

public abstract class SOACoreScribblerDomain extends DefaultScribblerDomain
      implements IScribblerDomain {

   private static final String EDIT_MODEL = "soa-edit-model:"; //$NON-NLS-1$

   private final String        label;

   public SOACoreScribblerDomain(IProject theContainingProject) {
      Assert.isNotNull(theContainingProject);
      label = EDIT_MODEL + theContainingProject.getName();
   }

   public String getEditModelLabel() {
      return label;
   }

}
