/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

/**
 * A ModuleImplementation provides a facade to update the &lt;moduleComponent
 * /&gt; attributes.
 * 
 * @since 1.0
 * 
 */
public interface ModuleImplementation extends Implementation {

   /**
    * Set the value of the <i>module</i> attribute for the &lt;moduleComponent
    * /&gt;. See the SCA2 documentation on &lt;moduleComponent /&gt; for more
    * information.
    * 
    * @param aModule
    *           In general, the <i>module</i> attribute identifies a relative
    *           path to identify an SCA-compliant Module definition.
    */
   void setModule(String aModule);

   /**
    * Return the value of the <i>module</i> attribute for the
    * &lt;moduleComponent /&gt;. See the SCA2 documentation on
    * &lt;moduleComponent /&gt; for more information.
    * 
    * @return In general, the <i>module</i> attribute identifies a relative
    *         path to identify an SCA-compliant Module definition.
    */
   String getModule();

   /**
    * Set the value of the <i>uri</i> attribute for the &lt;moduleComponent
    * /&gt;. See the SCA2 documentation on &lt;moduleComponent /&gt; for more
    * information.
    * 
    * @param aUri
    *           In general, the <i>uri</i> attribute defines a prefix that will
    *           identify the specific &lt;moduleComponent /&gt; in the context
    *           of a Subsystem. Use the <i>uri</i> to resolve errors resultant
    *           from duplicate module names.
    */
   void setUri(String aUri);

   /**
    * Return the value of the <i>uri</i> attribute for the &lt;moduleComponent
    * /&gt;. See the SCA2 documentation on &lt;moduleComponent /&gt; for more
    * information.
    * 
    * @return In general, the <i>uri</i> attribute defines a prefix that will
    *         identify the specific &lt;moduleComponent /&gt; in the context of
    *         a Subsystem. Use the <i>uri</i> to resolve errors resultant from
    *         duplicate module names.
    */
   String getUri();

}
