/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc --> A representation of the literals of the enumeration '<em><b>Override Options</b></em>',
 * and utility methods for working with them. <!-- end-user-doc -->
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getOverrideOptions()
 * @model
 * @generated
 */
public final class OverrideOptions extends AbstractEnumerator {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String             copyright    = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The '<em><b>No</b></em>' literal value. <!-- begin-user-doc -->
    * <p>
    * If the meaning of '<em><b>No</b></em>' literal object isn't clear,
    * there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @see #NO_LITERAL
    * @model name="no"
    * @generated
    * @ordered
    */
   public static final int                NO           = 0;

   /**
    * The '<em><b>May</b></em>' literal value. <!-- begin-user-doc -->
    * <p>
    * If the meaning of '<em><b>May</b></em>' literal object isn't clear,
    * there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @see #MAY_LITERAL
    * @model name="may"
    * @generated
    * @ordered
    */
   public static final int                MAY          = 1;

   /**
    * The '<em><b>Must</b></em>' literal value. <!-- begin-user-doc -->
    * <p>
    * If the meaning of '<em><b>Must</b></em>' literal object isn't clear,
    * there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @see #MUST_LITERAL
    * @model name="must"
    * @generated
    * @ordered
    */
   public static final int                MUST         = 2;

   /**
    * The '<em><b>No</b></em>' literal object. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @see #NO
    * @generated
    * @ordered
    */
   public static final OverrideOptions    NO_LITERAL   = new OverrideOptions(
                                                             NO, "no");                                                                                        //$NON-NLS-1$

   /**
    * The '<em><b>May</b></em>' literal object. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @see #MAY
    * @generated
    * @ordered
    */
   public static final OverrideOptions    MAY_LITERAL  = new OverrideOptions(
                                                             MAY, "may");                                                                                      //$NON-NLS-1$

   /**
    * The '<em><b>Must</b></em>' literal object. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @see #MUST
    * @generated
    * @ordered
    */
   public static final OverrideOptions    MUST_LITERAL = new OverrideOptions(
                                                             MUST, "must");                                                                                    //$NON-NLS-1$

   /**
    * An array of all the '<em><b>Override Options</b></em>' enumerators.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   private static final OverrideOptions[] VALUES_ARRAY = new OverrideOptions[] {
         NO_LITERAL, MAY_LITERAL, MUST_LITERAL,       };

   /**
    * A public read-only list of all the '<em><b>Override Options</b></em>'
    * enumerators. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final List               VALUES       = Collections
                                                             .unmodifiableList(Arrays
                                                                   .asList(VALUES_ARRAY));

   /**
    * Returns the '<em><b>Override Options</b></em>' literal with the
    * specified name. <!-- begin-user-doc -->
    * 
    * @param name
    *           The literal value of a particular OverrideOptions enum
    * @return The OverrideOptions with the literal value <i>name</i> <!--
    *         end-user-doc -->
    * @generated
    */
   public static OverrideOptions get(String name) {
      for (int i = 0; i < VALUES_ARRAY.length; ++i) {
         OverrideOptions result = VALUES_ARRAY[i];
         if (result.toString().equals(name)) {
            return result;
         }
      }
      return null;
   }

   /**
    * Returns the '<em><b>Override Options</b></em>' literal with the
    * specified value. <!-- begin-user-doc -->
    * 
    * @param value
    *           The value of a particular OverrideOptions enum
    * @return The OverrideOptions with the value <i>name</i> <!-- end-user-doc
    *         -->
    * @generated
    */
   public static OverrideOptions get(int value) {
      switch (value) {
         case NO:
            return NO_LITERAL;
         case MAY:
            return MAY_LITERAL;
         case MUST:
            return MUST_LITERAL;
      }
      return null;
   }

   /**
    * Only this class can construct instances. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   private OverrideOptions(int value, String name) {
      super(value, name);
   }

} // OverrideOptions
