/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Property</b></em>'.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.Property#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.Property#getDefault <em>Default</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.Property#isMany <em>Many</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.Property#getName <em>Name</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.Property#isRequired <em>Required</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.Property#getType <em>Type</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.Property#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getProperty()
 * @model extendedMetaData="name='Property' kind='elementOnly'"
 * @extends SCAObject
 * @generated
 */
public interface Property extends SCAObject {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * Returns the value of the '<em><b>Any</b></em>' attribute list. The
    * list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any</em>' attribute list isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getProperty_Any()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='elementWildcard'
    *        wildcards='##other' name=':0' processing='lax'"
    * @generated
    */
   FeatureMap getAny();

   /**
    * Returns the value of the '<em><b>Default</b></em>' attribute. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Default</em>' attribute isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Default</em>' attribute.
    * @see #setDefault(String)
    * @see org.eclipse.stp.core.sca.SCAPackage#getProperty_Default()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String"
    *        extendedMetaData="kind='attribute' name='default'"
    * @generated
    */
   String getDefault();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.Property#getDefault <em>Default</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Default</em>' attribute.
    * @see #getDefault()
    * @generated
    */
   void setDefault(String value);

   /**
    * Returns the value of the '<em><b>Many</b></em>' attribute. The
    * default value is <code>"false"</code>. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Many</em>' attribute isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Many</em>' attribute.
    * @see #isSetMany()
    * @see #unsetMany()
    * @see #setMany(boolean)
    * @see org.eclipse.stp.core.sca.SCAPackage#getProperty_Many()
    * @model default="false" unique="false" unsettable="true"
    *        dataType="org.eclipse.emf.ecore.xml.type.Boolean"
    *        extendedMetaData="kind='attribute' name='many'"
    * @generated
    */
   boolean isMany();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.Property#isMany <em>Many</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Many</em>' attribute.
    * @see #isSetMany()
    * @see #unsetMany()
    * @see #isMany()
    * @generated
    */
   void setMany(boolean value);

   /**
    * Unsets the value of the '{@link org.eclipse.stp.core.sca.Property#isMany <em>Many</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #isSetMany()
    * @see #isMany()
    * @see #setMany(boolean)
    * @generated
    */
   void unsetMany();

   /**
    * Returns whether the value of the '{@link org.eclipse.stp.core.sca.Property#isMany <em>Many</em>}'
    * attribute is set. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return whether the value of the '<em>Many</em>' attribute is set.
    * @see #unsetMany()
    * @see #isMany()
    * @see #setMany(boolean)
    * @generated
    */
   boolean isSetMany();

   /**
    * Returns the value of the '<em><b>Name</b></em>' attribute. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Name</em>' attribute isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Name</em>' attribute.
    * @see #setName(String)
    * @see org.eclipse.stp.core.sca.SCAPackage#getProperty_Name()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.NCName"
    *        required="true" extendedMetaData="kind='attribute' name='name'"
    * @generated
    */
   String getName();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.Property#getName <em>Name</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Name</em>' attribute.
    * @see #getName()
    * @generated
    */
   void setName(String value);

   /**
    * Returns the value of the '<em><b>Required</b></em>' attribute. The
    * default value is <code>"false"</code>. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Required</em>' attribute isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Required</em>' attribute.
    * @see #isSetRequired()
    * @see #unsetRequired()
    * @see #setRequired(boolean)
    * @see org.eclipse.stp.core.sca.SCAPackage#getProperty_Required()
    * @model default="false" unique="false" unsettable="true"
    *        dataType="org.eclipse.emf.ecore.xml.type.Boolean"
    *        extendedMetaData="kind='attribute' name='required'"
    * @generated
    */
   boolean isRequired();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.Property#isRequired <em>Required</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Required</em>' attribute.
    * @see #isSetRequired()
    * @see #unsetRequired()
    * @see #isRequired()
    * @generated
    */
   void setRequired(boolean value);

   /**
    * Unsets the value of the '{@link org.eclipse.stp.core.sca.Property#isRequired <em>Required</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #isSetRequired()
    * @see #isRequired()
    * @see #setRequired(boolean)
    * @generated
    */
   void unsetRequired();

   /**
    * Returns whether the value of the '{@link org.eclipse.stp.core.sca.Property#isRequired <em>Required</em>}'
    * attribute is set. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return whether the value of the '<em>Required</em>' attribute is set.
    * @see #unsetRequired()
    * @see #isRequired()
    * @see #setRequired(boolean)
    * @generated
    */
   boolean isSetRequired();

   /**
    * Returns the value of the '<em><b>Type</b></em>' attribute. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Type</em>' attribute isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Type</em>' attribute.
    * @see #setType(Object)
    * @see org.eclipse.stp.core.sca.SCAPackage#getProperty_Type()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.QName"
    *        required="true" extendedMetaData="kind='attribute' name='type'"
    * @generated
    */
   Object getType();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.Property#getType <em>Type</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Type</em>' attribute.
    * @see #getType()
    * @generated
    */
   void setType(Object value);

   /**
    * Returns the value of the '<em><b>Any Attribute</b></em>' attribute
    * list. The list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any Attribute</em>' attribute list isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any Attribute</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getProperty_AnyAttribute()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='attributeWildcard'
    *        wildcards='##any' name=':6' processing='lax'"
    * @generated
    */
   FeatureMap getAnyAttribute();

} // Property
