/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc --> The <b>Factory</b> for the model. It provides a
 * create method for each non-abstract class of the model.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage
 * @generated
 */
public interface SCAFactory extends EFactory {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String     copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The singleton instance of the factory. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   SCAFactory eINSTANCE = new org.eclipse.stp.core.sca.impl.SCAFactoryImpl();

   /**
    * Returns a new object of class '<em>Abstract Implementation</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Abstract Implementation</em>'.
    * @generated
    */
   AbstractImplementation createAbstractImplementation();

   /**
    * Returns a new object of class '<em>Binding</em>'. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Binding</em>'.
    * @generated
    */
   Binding createBinding();

   /**
    * Returns a new object of class '<em>Component Type</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Component Type</em>'.
    * @generated
    */
   ComponentType createComponentType();

   /**
    * Returns a new object of class '<em>Composite</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Composite</em>'.
    * @generated
    */
   Composite createComposite();

   /**
    * Returns a new object of class '<em>Entry Point</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Entry Point</em>'.
    * @generated
    */
   EntryPoint createEntryPoint();

   /**
    * Returns a new object of class '<em>External Service</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>External Service</em>'.
    * @generated
    */
   ExternalService createExternalService();

   /**
    * Returns a new object of class '<em>Implementation Component</em>'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Implementation Component</em>'.
    * @generated
    */
   ImplementationComponent createImplementationComponent();

   /**
    * Returns a new object of class '<em>Interface</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Interface</em>'.
    * @generated
    */
   Interface createInterface();

   /**
    * Returns a new object of class '<em>Java Implementation</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Java Implementation</em>'.
    * @generated
    */
   JavaImplementation createJavaImplementation();

   /**
    * Returns a new object of class '<em>Java Interface</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Java Interface</em>'.
    * @generated
    */
   JavaInterface createJavaInterface();

   /**
    * Returns a new object of class '<em>Module</em>'. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Module</em>'.
    * @generated
    */
   Module createModule();

   /**
    * Returns a new object of class '<em>Module Component</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Module Component</em>'.
    * @generated
    */
   ModuleComponent createModuleComponent();

   /**
    * Returns a new object of class '<em>Module Fragment</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Module Fragment</em>'.
    * @generated
    */
   ModuleFragment createModuleFragment();

   /**
    * Returns a new object of class '<em>Module Reference</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Module Reference</em>'.
    * @generated
    */
   ModuleReference createModuleReference();

   /**
    * Returns a new object of class '<em>Module Service</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Module Service</em>'.
    * @generated
    */
   ModuleService createModuleService();

   /**
    * Returns a new object of class '<em>Module Wire</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Module Wire</em>'.
    * @generated
    */
   ModuleWire createModuleWire();

   /**
    * Returns a new object of class '<em>Property</em>'. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Property</em>'.
    * @generated
    */
   Property createProperty();

   /**
    * Returns a new object of class '<em>Property Value</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Property Value</em>'.
    * @generated
    */
   PropertyValue createPropertyValue();

   /**
    * Returns a new object of class '<em>Property Values Set</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Property Values Set</em>'.
    * @generated
    */
   PropertyValuesSet createPropertyValuesSet();

   /**
    * Returns a new object of class '<em>Reference</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Reference</em>'.
    * @generated
    */
   Reference createReference();

   /**
    * Returns a new object of class '<em>Reference Value</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Reference Value</em>'.
    * @generated
    */
   ReferenceValue createReferenceValue();

   /**
    * Returns a new object of class '<em>Reference Values Set</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Reference Values Set</em>'.
    * @generated
    */
   ReferenceValuesSet createReferenceValuesSet();

   /**
    * Returns a new object of class '<em>Binding</em>'. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Binding</em>'.
    * @generated
    */
   SCABinding createSCABinding();

   /**
    * Returns a new object of class '<em>Core Root</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Core Root</em>'.
    * @generated
    */
   SCACoreRoot createSCACoreRoot();

   /**
    * Returns a new object of class '<em>Service</em>'. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Service</em>'.
    * @generated
    */
   Service createService();

   /**
    * Returns a new object of class '<em>SLSB Binding</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>SLSB Binding</em>'.
    * @generated
    */
   SLSBBinding createSLSBBinding();

   /**
    * Returns a new object of class '<em>Subsystem</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Subsystem</em>'.
    * @generated
    */
   Subsystem createSubsystem();

   /**
    * Returns a new object of class '<em>System Wire</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>System Wire</em>'.
    * @generated
    */
   SystemWire createSystemWire();

   /**
    * Returns a new object of class '<em>Unknown Implementation</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Unknown Implementation</em>'.
    * @generated
    */
   UnknownImplementation createUnknownImplementation();

   /**
    * Returns a new object of class '<em>Web Service Binding</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>Web Service Binding</em>'.
    * @generated
    */
   WebServiceBinding createWebServiceBinding();

   /**
    * Returns a new object of class '<em>WSDL Port Type</em>'. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return a new object of class '<em>WSDL Port Type</em>'.
    * @generated
    */
   WSDLPortType createWSDLPortType();

   /**
    * Returns the package supported by this factory. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @return the package supported by this factory.
    * @generated
    */
   SCAPackage getSCAPackage();

   /**
    * Create an instance of {@link ImplementationComponent}
    * 
    * @return An new instance of {@link ImplementationComponent}
    */
   Component createComponent();

} // SCAFactory
