/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

import java.util.List;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Subsystem</b></em>'.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.Subsystem#getWires <em>Wires</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.Subsystem#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.Subsystem#getUri <em>Uri</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.Subsystem#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getSubsystem()
 * @model extendedMetaData="name='Subsystem' kind='elementOnly'"
 * @generated
 */
public interface Subsystem extends Composite {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * Returns the value of the '<em><b>Wires</b></em>' containment
    * reference list. The list contents are of type
    * {@link org.eclipse.stp.core.sca.SystemWire}. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Wires</em>' containment reference list
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Wires</em>' containment reference list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getSubsystem_Wires()
    * @model type="org.eclipse.stp.core.sca.SystemWire" containment="true"
    *        resolveProxies="false" extendedMetaData="kind='element'
    *        name='wire'"
    * @generated
    */
   List getWires();

   /**
    * Returns the value of the '<em><b>Any</b></em>' attribute list. The
    * list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any</em>' attribute list isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getSubsystem_Any()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='elementWildcard'
    *        wildcards='##other' name=':6' processing='lax'"
    * @generated
    */
   FeatureMap getAny();

   /**
    * Returns the value of the '<em><b>Uri</b></em>' attribute. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Uri</em>' attribute isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Uri</em>' attribute.
    * @see #setUri(String)
    * @see org.eclipse.stp.core.sca.SCAPackage#getSubsystem_Uri()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.AnyURI"
    *        extendedMetaData="kind='attribute' name='uri'"
    * @generated
    */
   String getUri();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.Subsystem#getUri <em>Uri</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Uri</em>' attribute.
    * @see #getUri()
    * @generated
    */
   void setUri(String value);

   /**
    * Returns the value of the '<em><b>Any Attribute</b></em>' attribute
    * list. The list contents are of type
    * {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}. <!-- begin-user-doc
    * -->
    * <p>
    * If the meaning of the '<em>Any Attribute</em>' attribute list isn't
    * clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Any Attribute</em>' attribute list.
    * @see org.eclipse.stp.core.sca.SCAPackage#getSubsystem_AnyAttribute()
    * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry"
    *        many="true" extendedMetaData="kind='attributeWildcard'
    *        wildcards='##any' name=':8' processing='lax'"
    * @generated
    */
   FeatureMap getAnyAttribute();

} // Subsystem
