/**
 * <copyright> </copyright>
 * 
 * $Id: ImplementationComponentImpl.java,v 1.2 2006-04-05 14:26:12 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.util.FeatureMap.Entry;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.introspection.ModelIntrospectionManager;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.introspection.IComponentTypeIntrospector;
import org.eclipse.stp.core.introspection.IModelIntrospectionManager;
import org.eclipse.stp.core.sca.AbstractImplementation;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.ImplementationComponent;
import org.eclipse.stp.core.sca.PropertyValuesSet;
import org.eclipse.stp.core.sca.ReferenceValuesSet;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Implementation Component</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.ImplementationComponentImpl#getImplementationGroup <em>Implementation Group</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ImplementationComponentImpl#getImplementation <em>Implementation</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ImplementationComponentImpl#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ImplementationComponentImpl#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ImplementationComponentImpl extends ComponentImpl implements
      ImplementationComponent {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright           = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getImplementationGroup() <em>Implementation Group</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getImplementationGroup()
    * @generated
    * @ordered
    */
   protected FeatureMap       implementationGroup = null;

   /**
    * The cached value of the '{@link #getAny() <em>Any</em>}' attribute list.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAny()
    * @generated
    * @ordered
    */
   protected FeatureMap       any                 = null;

   /**
    * The cached value of the '{@link #getAnyAttribute() <em>Any Attribute</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAnyAttribute()
    * @generated
    * @ordered
    */
   protected FeatureMap       anyAttribute        = null;

   /* ****** Begin Custom Fields ********** */

   private ComponentType      componentType;

   /* ****** End Custom Fields ********** */

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ImplementationComponentImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getImplementationComponent();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getImplementationGroup() {
      if (implementationGroup == null) {
         implementationGroup = new BasicFeatureMap(this,
               SCAPackage.IMPLEMENTATION_COMPONENT__IMPLEMENTATION_GROUP);
      }
      return implementationGroup;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Implementation getImplementation() {
      return (Implementation) getImplementationGroup().get(
            SCAPackage.eINSTANCE.getImplementationComponent_Implementation(),
            true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetImplementation(
         Implementation newImplementation, NotificationChain msgs) {
      return ((FeatureMap.Internal) getImplementationGroup()).basicAdd(
            SCAPackage.eINSTANCE.getImplementationComponent_Implementation(),
            newImplementation, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setImplementationGen(Implementation newImplementation) {
      ((FeatureMap.Internal) getImplementationGroup()).set(SCAPackage.eINSTANCE
            .getImplementationComponent_Implementation(), newImplementation);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAny() {
      if (any == null) {
         any = new BasicFeatureMap(this,
               SCAPackage.IMPLEMENTATION_COMPONENT__ANY);
      }
      return any;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAnyAttribute() {
      if (anyAttribute == null) {
         anyAttribute = new BasicFeatureMap(this,
               SCAPackage.IMPLEMENTATION_COMPONENT__ANY_ATTRIBUTE);
      }
      return anyAttribute;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseAdd(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.IMPLEMENTATION_COMPONENT__REFERENCE_VALUES_SET:
               if (referenceValuesSet != null)
                  msgs = ((InternalEObject) referenceValuesSet)
                        .eInverseRemove(
                              this,
                              EOPPOSITE_FEATURE_BASE
                                    - SCAPackage.IMPLEMENTATION_COMPONENT__REFERENCE_VALUES_SET,
                              null, msgs);
               return basicSetReferenceValuesSet((ReferenceValuesSet) otherEnd,
                     msgs);
            default:
               return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
         }
      }
      if (eContainer != null)
         msgs = eBasicRemoveFromContainer(msgs);
      return eBasicSetContainer(otherEnd, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.IMPLEMENTATION_COMPONENT__PROPERTY_VALUES_SET:
               return basicSetPropertyValuesSet(null, msgs);
            case SCAPackage.IMPLEMENTATION_COMPONENT__REFERENCE_VALUES_SET:
               return basicSetReferenceValuesSet(null, msgs);
            case SCAPackage.IMPLEMENTATION_COMPONENT__IMPLEMENTATION_GROUP:
               return ((InternalEList) getImplementationGroup()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.IMPLEMENTATION_COMPONENT__IMPLEMENTATION:
               return basicSetImplementation(null, msgs);
            case SCAPackage.IMPLEMENTATION_COMPONENT__ANY:
               return ((InternalEList) getAny()).basicRemove(otherEnd, msgs);
            case SCAPackage.IMPLEMENTATION_COMPONENT__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.IMPLEMENTATION_COMPONENT__PROPERTY_VALUES_SET:
            return getPropertyValuesSet();
         case SCAPackage.IMPLEMENTATION_COMPONENT__REFERENCE_VALUES_SET:
            return getReferenceValuesSet();
         case SCAPackage.IMPLEMENTATION_COMPONENT__NAME:
            return getName();
         case SCAPackage.IMPLEMENTATION_COMPONENT__IMPLEMENTATION_GROUP:
            return getImplementationGroup();
         case SCAPackage.IMPLEMENTATION_COMPONENT__IMPLEMENTATION:
            return getImplementation();
         case SCAPackage.IMPLEMENTATION_COMPONENT__ANY:
            return getAny();
         case SCAPackage.IMPLEMENTATION_COMPONENT__ANY_ATTRIBUTE:
            return getAnyAttribute();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.IMPLEMENTATION_COMPONENT__PROPERTY_VALUES_SET:
            setPropertyValuesSet((PropertyValuesSet) newValue);
            return;
         case SCAPackage.IMPLEMENTATION_COMPONENT__REFERENCE_VALUES_SET:
            setReferenceValuesSet((ReferenceValuesSet) newValue);
            return;
         case SCAPackage.IMPLEMENTATION_COMPONENT__NAME:
            setName((String) newValue);
            return;
         case SCAPackage.IMPLEMENTATION_COMPONENT__IMPLEMENTATION_GROUP:
            getImplementationGroup().clear();
            getImplementationGroup().addAll((Collection) newValue);
            return;
         case SCAPackage.IMPLEMENTATION_COMPONENT__IMPLEMENTATION:
            setImplementation((Implementation) newValue);
            return;
         case SCAPackage.IMPLEMENTATION_COMPONENT__ANY:
            getAny().clear();
            getAny().addAll((Collection) newValue);
            return;
         case SCAPackage.IMPLEMENTATION_COMPONENT__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.IMPLEMENTATION_COMPONENT__PROPERTY_VALUES_SET:
            setPropertyValuesSet((PropertyValuesSet) null);
            return;
         case SCAPackage.IMPLEMENTATION_COMPONENT__REFERENCE_VALUES_SET:
            setReferenceValuesSet((ReferenceValuesSet) null);
            return;
         case SCAPackage.IMPLEMENTATION_COMPONENT__NAME:
            setName(NAME_EDEFAULT);
            return;
         case SCAPackage.IMPLEMENTATION_COMPONENT__IMPLEMENTATION_GROUP:
            getImplementationGroup().clear();
            return;
         case SCAPackage.IMPLEMENTATION_COMPONENT__IMPLEMENTATION:
            setImplementation((Implementation) null);
            return;
         case SCAPackage.IMPLEMENTATION_COMPONENT__ANY:
            getAny().clear();
            return;
         case SCAPackage.IMPLEMENTATION_COMPONENT__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.IMPLEMENTATION_COMPONENT__PROPERTY_VALUES_SET:
            return propertyValuesSet != null;
         case SCAPackage.IMPLEMENTATION_COMPONENT__REFERENCE_VALUES_SET:
            return referenceValuesSet != null;
         case SCAPackage.IMPLEMENTATION_COMPONENT__NAME:
            return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
                  .equals(name);
         case SCAPackage.IMPLEMENTATION_COMPONENT__IMPLEMENTATION_GROUP:
            return implementationGroup != null
                  && !implementationGroup.isEmpty();
         case SCAPackage.IMPLEMENTATION_COMPONENT__IMPLEMENTATION:
            return getImplementation() != null;
         case SCAPackage.IMPLEMENTATION_COMPONENT__ANY:
            return any != null && !any.isEmpty();
         case SCAPackage.IMPLEMENTATION_COMPONENT__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (implementationGroup: "); //$NON-NLS-1$
      result.append(implementationGroup);
      result.append(", any: "); //$NON-NLS-1$
      result.append(any);
      result.append(", anyAttribute: "); //$NON-NLS-1$
      result.append(anyAttribute);
      result.append(')');
      return result.toString();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public void setImplementation(Implementation newImplementation) {
      ((FeatureMap.Internal) getImplementationGroup()).set(SCAPackage.eINSTANCE
            .getImplementationComponent_Implementation(), newImplementation);
   }

   public Implementation setSpecializedImplementation(
         Implementation newImplementation) {

      EStructuralFeature feature = FeatureAdapter.getFeature(newImplementation);
      Assert.isNotNull(feature);
      Implementation oldImplementation = null;
      FeatureMap.Internal featureMap = ((FeatureMap.Internal) getImplementationGroup());
      if (featureMap.isEmpty())
         featureMap.add(feature, newImplementation);
      else {
         FeatureMap.Entry entry = (FeatureMap.Entry) featureMap.remove(0);
         oldImplementation = (Implementation) entry.getValue();
         featureMap.add(feature, newImplementation);
      }
      componentType = null;
      return oldImplementation;

   }

   public Implementation setAbstractImplementation(
         ComponentType newComponentType) {
      Implementation currentImplementation = null;
      FeatureMap.Internal implementationGroup = (FeatureMap.Internal) getImplementationGroup();

      // prep the old one
      if (!implementationGroup.isEmpty()) {
         FeatureMap.Entry entry = (Entry) implementationGroup.remove(0);
         currentImplementation = (Implementation) entry.getValue();
         if (FeatureAdapter.getFeature(currentImplementation) == null)
            FeatureAdapter.setFeature(currentImplementation, entry
                  .getEStructuralFeature());
      }
      // clean up the component type
      IComponentTypeIntrospector introspector = (IComponentTypeIntrospector) EcoreUtil
            .getAdapter(newComponentType.getEObject().eAdapters(),
                  IComponentTypeIntrospector.ADAPTER_TYPE);
      if (introspector != null) {
         newComponentType.getEObject().eAdapters().remove(introspector);
         introspector.dispose();
      }

      // set the abstract implementation
      AbstractImplementation abstractImplementation = SCAFactory.eINSTANCE
            .createAbstractImplementation();
      abstractImplementation.setComponentType(newComponentType);
      getImplementationGroup().set(
            SCAPackage.eINSTANCE.getSCACoreRoot_ImplementationAbstract(),
            abstractImplementation);

      return currentImplementation;

   }

   public int getState() {
      Implementation impl = getImplementation();
      if (impl == null)
         return STATE_ABSTRACT;
      if (impl instanceof AbstractImplementation) {
         AbstractImplementation abstractImplementation = (AbstractImplementation) impl;
         if (abstractImplementation.getType() != null)
            return STATE_TYPED;
         return STATE_ABSTRACT;
      }
      return STATE_IMPLEMENTED;
   }

   public String getType() {
      switch (getState()) {
         case STATE_TYPED: {
            AbstractImplementation impl = (AbstractImplementation) getImplementation();
            return impl.getType();
         }
         case STATE_IMPLEMENTED: {
            EStructuralFeature feature = getImplementationFeature();
            Assert.isNotNull(feature);
            return ExtendedMetaData.INSTANCE.getName(feature);
         }
         case STATE_ABSTRACT:
         default:
            return TYPE_ABSTRACT;
      }
   }

   /**
    * 
    * @return The ComponentType contract for this Component
    */
   public ComponentType resolveComponentType() {
      if (componentType != null)
         return componentType;
      synchronized (this) {
         boolean hasAbstractImplementation = hasAbstractImplementation();
         Assert
               .isTrue(hasAbstractImplementation
                     || (eResource() != null && eResource().getResourceSet() != null));

         if (hasAbstractImplementation)
            componentType = resolveAbstractComponentType();
         else if (componentType == null && !getImplementationGroup().isEmpty()) {
            componentType = IModelIntrospectionManager.eINSTANCE
                  .resolve(getImplementation());
         }
      }
      return componentType;
   }

   private EStructuralFeature getImplementationFeature() {
      return ModelIntrospectionManager
            .getStructuralFeature(getImplementation());
   }

   private ComponentType resolveAbstractComponentType() {
      AbstractImplementation abstractImpl = (AbstractImplementation) getImplementation();
      return abstractImpl == null ? null : abstractImpl.getComponentType();
   }

   private boolean hasAbstractImplementation() {
      Implementation impl = getImplementation();
      return impl != null && impl instanceof AbstractImplementation;
   }

} // ImplementationComponentImpl
