/**
 * <copyright> </copyright>
 * 
 * $Id: PropertyValueItemProvider.java,v 1.2 2006-04-05 14:26:13 melder Exp $
 */
package org.eclipse.stp.core.sca.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.PropertyValue;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * This is the item provider adapter for a
 * {@link org.eclipse.stp.core.sca.PropertyValue} object. <!-- begin-user-doc
 * --> <!-- end-user-doc -->
 * 
 * @generated
 */
public class PropertyValueItemProvider extends ItemProviderAdapter implements
      IEditingDomainItemProvider, IStructuredItemContentProvider,
      ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * This constructs an instance from a factory and a notifier. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public PropertyValueItemProvider(AdapterFactory adapterFactory) {
      super(adapterFactory);
   }

   /**
    * This returns the property descriptors for the adapted class. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getPropertyDescriptors(Object object) {
      if (itemPropertyDescriptors == null) {
         super.getPropertyDescriptors(object);

         addValuePropertyDescriptor(object);
         addNamePropertyDescriptor(object);
      }
      return itemPropertyDescriptors;
   }

   /**
    * This adds a property descriptor for the Value feature. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected void addValuePropertyDescriptor(Object object) {
      itemPropertyDescriptors
            .add(createItemPropertyDescriptor(
                  ((ComposeableAdapterFactory) adapterFactory)
                        .getRootAdapterFactory(),
                  getResourceLocator(),
                  getString("_UI_PropertyValue_value_feature"), //$NON-NLS-1$
                  getString(
                        "_UI_PropertyDescriptor_description", "_UI_PropertyValue_value_feature", "_UI_PropertyValue_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
                  SCAPackage.eINSTANCE.getPropertyValue_Value(), true,
                  ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
   }

   /**
    * This adds a property descriptor for the Name feature. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected void addNamePropertyDescriptor(Object object) {
      itemPropertyDescriptors
            .add(createItemPropertyDescriptor(
                  ((ComposeableAdapterFactory) adapterFactory)
                        .getRootAdapterFactory(),
                  getResourceLocator(),
                  getString("_UI_PropertyValue_name_feature"), //$NON-NLS-1$
                  getString(
                        "_UI_PropertyDescriptor_description", "_UI_PropertyValue_name_feature", "_UI_PropertyValue_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
                  SCAPackage.eINSTANCE.getPropertyValue_Name(), true,
                  ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
   }

   /**
    * This returns PropertyValue.gif. <!-- begin-user-doc --> <!-- end-user-doc
    * -->
    * 
    * @generated
    */
   public Object getImage(Object object) {
      return getResourceLocator().getImage("full/obj16/PropertyValue"); //$NON-NLS-1$
   }

   /**
    * This returns the label text for the adapted class. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getText(Object object) {
      String label = ((PropertyValue) object).getName();
      return label == null || label.length() == 0 ? getString("_UI_PropertyValue_type") : //$NON-NLS-1$
            getString("_UI_PropertyValue_type") + " " + label; //$NON-NLS-1$ //$NON-NLS-2$
   }

   /**
    * This handles model notifications by calling {@link #updateChildren} to
    * update any cached children and by creating a viewer notification, which it
    * passes to {@link #fireNotifyChanged}. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   public void notifyChanged(Notification notification) {
      updateChildren(notification);

      switch (notification.getFeatureID(PropertyValue.class)) {
         case SCAPackage.PROPERTY_VALUE__VALUE:
         case SCAPackage.PROPERTY_VALUE__NAME:
            fireNotifyChanged(new ViewerNotification(notification, notification
                  .getNotifier(), false, true));
            return;
      }
      super.notifyChanged(notification);
   }

   /**
    * This adds to the collection of
    * {@link org.eclipse.emf.edit.command.CommandParameter}s describing all of
    * the children that can be created under this object. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected void collectNewChildDescriptors(Collection newChildDescriptors,
         Object object) {
      super.collectNewChildDescriptors(newChildDescriptors, object);
   }

   /**
    * Return the resource locator for this item provider's resources. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ResourceLocator getResourceLocator() {
      return STPCorePlugin.INSTANCE;
   }

}
