/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.saf.impl;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.stp.core.sca.WireSource;
import org.eclipse.stp.core.sca.WireTarget;

/**
 * This class holds the utilities methods. 
 */
public class SAFManagerUtils {

	/**
	 * Test if the given source reference can be connected to one of 
	 * the given target interfaces. 
	 * 
	 * @param source source reference
	 * @param targets target interfaces
	 * @return <code>true</code> if source and target can be connected; 
	 * <code>false</code> otherwise
	 */
	static public boolean interfacesMatchReference(WireSource source, WireTarget[] targets)
	{
		if ((source == null) || (targets == null)) {
			return false;
		}
		
		boolean allMatched = true;
		int maxCount = targets.length;
		if (maxCount == 0) {
			// Nothing to match on the source part.
			allMatched = false;
		}
		else {
			for(int i = 0; i < maxCount; i++) {
				WireTarget target = targets[i];
				boolean matched = source.matches(target);
				if (!matched) {
					allMatched = false;
					break;
				}
			}//for
		}
		return allMatched;
	}

	/**
	 * @param anSCAObject
	 * @return the substitution group name for the given object
	 */
	public static String getSubstitutionGroupName(SCAObject anSCAObject) {
		return ExtendedMetaData.INSTANCE.getName(getStructuralFeature(anSCAObject));
	}

	private static EStructuralFeature getStructuralFeature(SCAObject anSCAObject) {
		FeatureAdapter adapter = null;
				
		Assert.isTrue((adapter = FeatureAdapter.findAdapter(anSCAObject)) != null ||
				anSCAObject.getEObject().eContainer().eContainingFeature() != null);
	
		if(adapter != null) 
			return adapter.getFeature();
		
		/* With the above assertion in place, feature cannot be null */
		EStructuralFeature feature = anSCAObject.getEObject().eContainingFeature();
		if (((EStructuralFeature.Internal) feature).isFeatureMap()) {
			FeatureMap map = (FeatureMap) anSCAObject.getEObject().eContainer().eGet(feature);
			return map.getEStructuralFeature(0);
		}
		return feature;		
	}

}
