/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class AssignedJava2WsdlAction extends Java2WSDLAction implements IWorkbenchWindowActionDelegate{
    
	private static final LoggingProxy LOG = LoggingProxy.getlogger(AssignedJava2WsdlAction.class);
	
	public void dispose() {
        // TODO Auto-generated method stub
        
    }

    public void init(IWorkbenchWindow window) {
        // TODO Auto-generated method stub
        
    }
    
    public void run(IAction action) {
        try {
        	IProject project = ResourceUtils.getActiveProject();
        	project.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, null);
        	String fileName = project.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_STARTING_POINT);
    		IFile file = project.getFile(new Path(fileName));
    		this.generate(file.getFullPath(), project, null);
    		project.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, null);
        } catch (Exception e) {
            LOG.error("java to wsdl action failure", e);
        }
    }
}
