/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.deploy;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;

public final class DeployGeneratorProxy {
    
    private static final String EXT_ELT_DEPLOY_GEN = "DeployGenerator";
    private static final String EXT_ATT_DEPLOY_GEN_CLASS = "class";

    //private static final LoggingProxy LOG = LoggingProxy.getlogger(DeployGeneratorProxy.class);
    
    private IConfigurationElement mConfigEl;
    
    private DeployGeneratorProxy() {
        IConfigurationElement[] cfgs = 
            Platform.getExtensionRegistry().getConfigurationElementsFor(ScJaxWsPlugin.EXT_POINT_SC_JAXWS_RUNTIME);
        
        for (int i = 0; i < cfgs.length && mConfigEl == null; i++) {
            if (cfgs[i].getName().equals(EXT_ELT_DEPLOY_GEN)) {
                mConfigEl = cfgs[i];
            }
        }
    }

    public static DeployGeneratorProxy getProxy() {
        return new DeployGeneratorProxy();
    }

    public void setInitializationData(IConfigurationElement config,
        String propertyName, Object data) throws CoreException {
    }

    public void generate(IPath path, IProject project, Object data) throws CoreException {
        IDeployGenerator mAction = 
            (IDeployGenerator)mConfigEl.createExecutableExtension(EXT_ATT_DEPLOY_GEN_CLASS);
        if (data != null) {
            mAction.setInitializationData(mConfigEl, null, data);
        }
        mAction.run(path, project);
    }
}
