/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.stp.sc.common.utils.JDTUtils;


public class JaxBindAnnotationUtils {
    
    public static final HashSet<String> JAXB_TABLE = new HashSet<String>();

    static {
        JAXB_TABLE.add("XmlAccessorType");
        JAXB_TABLE.add("XmlElement");
        JAXB_TABLE.add("XmlRootElement");
        JAXB_TABLE.add("XmlType");
    }

    protected JaxBindAnnotationUtils() {
    }
    
    public static String getAnnotationImport(Annotation annotation) {
        
        if (JAXB_TABLE.contains(annotation.getTypeName().toString())) {
            return XmlRootElement.class.getPackage().getName() + "." + annotation.getTypeName().toString();
        }

        return null;
    }

    public static SingleMemberAnnotation newXmlAccessorTypeAnnotation(CompilationUnit astRoot,
                                                                      Expression exp) {
        
        return JDTUtils.newSingleMemberAnnotation(astRoot, XmlAccessorType.class.getSimpleName(), exp);
    }

    public static NormalAnnotation newXmlTypeAnnotation(CompilationUnit astRoot, 
                                                        String name,
                                                        String[] propOrder) {
        
        List<MemberValuePair> annotValues = new ArrayList<MemberValuePair>();
        MemberValuePair valPair = JDTUtils.newMemberValuePair(astRoot, "name", name);
        annotValues.add(valPair);
        if (propOrder != null && propOrder.length != 0) {
            valPair = JDTUtils.newMemberValuePair(astRoot, "propOrder", propOrder);
            annotValues.add(valPair);
        }

        return JDTUtils.newNormalAnnotation(astRoot, XmlType.class.getSimpleName(), annotValues);
    }

    public static NormalAnnotation newXmlRootElemntAnnotation(CompilationUnit astRoot, String name) {

        ArrayList<MemberValuePair> annotValues = new ArrayList<MemberValuePair>();
        MemberValuePair valPair = JDTUtils.newMemberValuePair(astRoot, "name", name);
        annotValues.add(valPair);

        return JDTUtils.newNormalAnnotation(astRoot, XmlRootElement.class.getSimpleName(), annotValues);
    }

    public static NormalAnnotation newXmlElementAnnotation(CompilationUnit astRoot, 
                                                           String name, 
                                                           Boolean nillable,
                                                           String namespace, 
                                                           String defaultValue,
                                                           Type typeClass) {
        
        List<MemberValuePair> annotValues = new ArrayList<MemberValuePair>();

        if (name != null) {
            MemberValuePair valPair = JDTUtils.newMemberValuePair(astRoot, "name", name);
            annotValues.add(valPair);
        }

        if (nillable != null) {
            MemberValuePair valPair = JDTUtils.newMemberValuePair(astRoot, "nillable", nillable);
            annotValues.add(valPair);
        }

        if (namespace != null) {
            MemberValuePair valPair = JDTUtils.newMemberValuePair(astRoot, "namespace", namespace);
            annotValues.add(valPair);
        }

        if (defaultValue != null) {
            MemberValuePair valPair = JDTUtils.newMemberValuePair(astRoot, "defaultValue", defaultValue);
            annotValues.add(valPair);
        }
        
        
//        if (typeClass != null) {
//            MemberValuePair valPair = JDTUtils.newMemberValuePair(astRoot, "type", typeClass, false);
//            annotValues.add(valPair);
//        }

        return JDTUtils.newNormalAnnotation(astRoot, XmlElement.class.getSimpleName(), annotValues);
    }
}
