/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards.enablejaxws;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.common.internal.viewers.StpRuntimeComposite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntime;

public class RuntimeSelectionPage extends org.eclipse.stp.sc.jaxws.internal.wizards.RuntimeSelectionPage {

	private static final LoggingProxy LOG = LoggingProxy.getlogger(RuntimeSelectionPage.class);
	
	public RuntimeSelectionPage(String pageName, String title,
			ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
	}
	

	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		
		composite.setLayoutData(GridData.FILL_BOTH);
		composite.setLayout(new GridLayout());
		
		String[] moduleTypes = new String[] {RuntimeCore.JAXWS_MODULE_TYPE};
		
		runtimeComp = new StpRuntimeComposite(composite, SWT.NONE, 
				new StpRuntimeComposite.SelectionListener() {
			public void runtimeSelected(IRuntime runtime) {
				LOG.debug("runtime selected:" + runtime.getId());
				selectedRuntime = runtime;
				setPageComplete(validatePage());
				IWizardPage page = RuntimeSelectionPage.this.getWizard().getPage(JavaFirstEnableWizard.STARTING_POINT_PAGE_NAME);
				if(page != null && page instanceof StartingPointPage){
					((StartingPointPage)page).setRuntimeInfo(RuntimeSelectionPage.this.getRuntimeType(), RuntimeSelectionPage.this.getRuntimeID());
				}
			}
		}, moduleTypes);
		
		runtimeComp.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.FILL_VERTICAL));
		
		this.setControl(composite);
		setPageComplete(false);

	}
}
