/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards.enablejaxws;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;


public class StartingPointPage extends org.eclipse.stp.sc.jaxws.wizards.StartingPointWizardPage{
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(StartingPointPage.class);
	
	
	public StartingPointPage(String pageName) {
    	super(pageName);
    	this.setDescription("Specify the starting point as the web service class.");
    	this.setTitle("Starting Point");
    }
	
    public void performFinish(IProject project){
    	try{
    		//add starting point file to the project properties
    		String filePath = pageContents.getStartingPoint();
    		IFile targetFile = ResourceUtils.getFileFromPath(filePath);
    		project.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_STARTING_POINT, targetFile.getProjectRelativePath().toOSString());
    		
    		project.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, null);

    		annotateStartPointClass(project);
    		
            //select and open this java file 
            ResourceUtils.selectAndOpenResource(targetFile);
            
            ((IJavaProject)JavaCore.create(project)).save(null, false);
            project.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, null);

    	}catch(Exception ex){
    		LOG.error("error during import the starting point", ex);
    	}
    }
    
    public void updateControl(String newRuntimeType) {
    	//do nothing
    }
    
	public void setRuntimeInfo(String runtimeType, String runtimeID){
		((StartingPointPageContents)pageContents).setRuntimeInfo(runtimeType, runtimeID);
	}

}
