package org.eclipse.stp.sc.jaxwsri.kitprocessor;

import java.util.ArrayList;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.common.utils.RuntimeUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeKitProcessor;
import org.eclipse.wst.server.core.IRuntime;

public class JAXWSRIKitProcessorTemplate implements IRuntimeKitProcessor
{
	
	public void clearJavaProjectBuildPath(IJavaProject project)
	throws JavaModelException, CoreException {
		IRuntime runtime = RuntimeCore.getRuntime(project.getProject());
		String varName = RuntimeUtils.getRuntimeLibName(runtime);
		WorkspaceManager.removeEntriesFromClassPath(project, varName);	}

	public void completeJavaProjectBuildPath(IJavaProject project)
	throws JavaModelException, CoreException {
		IRuntime runtime = RuntimeCore.getRuntime(project.getProject());
        IClasspathEntry runtimeLib = RuntimeUtils.getRuntimeLib(runtime);
        if(runtimeLib != null){
            ArrayList<IClasspathEntry> clsLibs = new ArrayList<IClasspathEntry>();
            clsLibs.add(runtimeLib);
            WorkspaceManager.addEntriesToClassPath(project, clsLibs); 
        }
	}
}
