/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.rule.engine;

import java.util.LinkedList;

import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.xmlvalidator.rule.model.VRuleError;
import org.eclipse.stp.sc.xmlvalidator.rule.model.VRuleInstance;
import org.eclipse.stp.sc.xmlvalidator.utils.XMLUtils;
import org.w3c.dom.Document;

/**
 * @author jma
 * rule engine support both file based validation and in momory validation.
 *
 */
public class VRuleEngine {
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(VRuleEngine.class);

	protected VRuleManager ruleMgr;
	
	public VRuleEngine() {
		ruleMgr = VRuleManager.getInstance();
	}
	
	public void init() {
		int count = ruleMgr.loadRules();
		LOG.debug("validating rule engine start with " + count + " rules");
	}
	
	//to add rule path on the fly
	public synchronized int addRulePath(String rulePath) {
        return ruleMgr.loadRulesInPath(rulePath);
	}
	
	/**
	 * add a new rule file to the rule engine on the fly
	 * @param rulePath, the full path to the rule file
	 * @return, the rule id or null if error during load that rule
	 */
	public synchronized String addRule(String ruleFilePath) {
		return null;
	}
	
	
	/**
	 * remove one rule from engine according to rule id
	 * @param ruleID
	 */
	public synchronized void removeRule(String ruleID) {
        ruleMgr.removeOneRule(ruleID);
	}
	
	/**
	 * validate the xml file with rules. return the error message if any
	 * @param xmlFilePath
	 * @return, null if success, or the error messsags
	 */
	public synchronized VRuleError[] validate(String xmlFilePath) {
		Document dom = null;
		try {
		    dom = XMLUtils.loadXmlDocument(xmlFilePath);
		} catch (Exception e) {
			LOG.error("error during load xml file." + xmlFilePath, e);
			return null;
		} 
		return validate(dom);
	}
	
	/**
	 * validate the xml dom tree in memory, return the error message if any
	 * @param dom
	 * @return
	 */
	public synchronized VRuleError[] validate(Document dom) {
		LinkedList<VRuleError> errors = new LinkedList<VRuleError>();
		try {
			for (VRuleInstance rule : ruleMgr.ruleTable.values()) {
				if (!rule.getRuleDef().getEnabled()) {
					continue;
				}
                boolean ret = rule.validate(dom);
                if (!ret) {
                	errors.addAll(rule.getErrors());
                }
			}
			return errors.toArray(new VRuleError[0]);
		} catch (Exception e) {
			LOG.error("error during validting.", e);
			return null;
		}
	}
	
	 
	
	/**
	 * provide main class to run the validting from command line
	 * @param args
	 */
	public static void main(String args) {
		//add current path as default rule path if user do not assigned
	}
}
