/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.common.utils;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;


public final class UIUtils {
    private UIUtils() {
    }

    public static void selectWidget(Widget widget) {
        selectWidget(widget, true);
    }

    public static void selectWidget(Widget widget, int index) {
        Event event = new Event();
        event.widget = widget;

        if (widget instanceof Combo) {
            if (index < -1) {
                index = -1;
            }

            if (index == -1) {
                ((Combo)widget).deselectAll();
            }

            ((Combo)widget).select(index);
        }

        if (widget instanceof Table) {
            if (index == -1) {
                ((Table)widget).deselectAll();
            }

            ((Table)widget).select(index);
        }

        if (widget instanceof List) {
            if (index == -1) {
                ((List)widget).deselectAll();
            }

            ((List)widget).select(index);
        }

        if (widget instanceof Tree) {
            if (index == -1) {
                ((Tree)widget).deselectAll();
            }

            ((Tree)widget).setSelection(new TreeItem[] {
                ((Tree)widget).getItem(index)});
        }

        widget.notifyListeners(SWT.Selection, event);
    }

    public static void selectWidget(Widget widget, boolean selected) {
        Event event = new Event();
        event.widget = widget;

        if (widget instanceof Button) {
            Button button = (Button)widget;

            // if selecting a radio button, need to deselect all siblings
            if (selected && ((button.getStyle() & SWT.RADIO) != 0)) {
                Control[] children = button.getParent().getChildren();

                for (int i = 0; i < children.length; i++) {
                    Control child = children[i];

                    if ((widget != child) && child instanceof Button) {
                        ((Button)child).setSelection(false);
                    }
                }
            }

            ((Button)widget).setSelection(selected);
        }

        widget.notifyListeners(SWT.Selection, event);
    }

    public static String[] getStringsFromCommaSeparatedList(
        String commaSeparatedList) {
        String[] items = commaSeparatedList.split(",");

        return items;
    }

    public static String getNonNullValue(String value) {
        return (value == null) ? "" : value;
    }

    public static int getSelectedIndex(String selection, String[] choices) {
        for (int i = 0; i < choices.length; i++) {
            if (selection.equals(choices[i])) {
                return i;
            }
        }

        return 0;
    }

    public static void computeTableWidth(TableViewer tv) {
        computeTableWidth(tv.getTable());
    }

    public static void computeTableWidth(Table table) {
        int columnsAmount = table.getColumnCount();

        for (int i = 0; i < columnsAmount; i++) {
            table.getColumn(i)
                 .setWidth(table.getClientArea().width / columnsAmount);
        }
    }
}
