/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.common.annotations.ext;

import java.lang.annotation.Annotation;

/**
 * the resolver class is used to load annoation classes from correct plugin.
 * for example, the stp.sc.common plugin won't have dependency to jaxws api class.
 * In order to show those jaxws annotations in the annotation view, we need to define
 * JaxWsAnnotationResolver in the stp.sc.jaxws plugin to load those jaxws annotations 
 * @author jma
 *
 */
public interface IAnnotationResolver {

	public Class <? extends Annotation> loadAnnotationClass(String className)
	    throws ClassNotFoundException;
}
