/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IHelpConstants;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.emf.controls.EMFTextControl;
import org.eclipse.stp.soas.internal.deploy.ui.editors.DeployEditorSectionPart;
import org.eclipse.stp.soas.internal.deploy.ui.editors.EnhancedFormEditor;
import org.eclipse.stp.soas.internal.deploy.ui.help.HelpUtilities;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GeneralInfoSection
extends DeployEditorSectionPart {
    public static final String SECTION_TITLE = DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.SECTITLE.GeneralInfo");
    public static final String SECTION_DESC = DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.SECDESC.GeneralInfo");
    public static final String LABEL_NAME = DeployCorePlugin.getDefault().getResourceString("LABEL.Name");
    public static final String LABEL_DESCRIPTION = DeployCorePlugin.getDefault().getResourceString("LABEL.Description");
    private EMFTextControl mNameText;
    private EMFTextControl mDescText;
    private Root mRoot;

    public GeneralInfoSection(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
        this.getSection().setText(SECTION_TITLE);
        this.getSection().setDescription(SECTION_DESC);
    }

    public void createClient(FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)this.getSection());
        GridLayout layout = EnhancedFormEditor.newSectionGridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label label = toolkit.createLabel(container, LABEL_NAME);
        GridData gd = new GridData(2);
        label.setLayoutData((Object)gd);
        Text text = toolkit.createText(container, null);
        gd = new GridData(770);
        text.setLayoutData((Object)gd);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralInfoSection.this.handleNameModified();
            }
        });
        this.mNameText = new EMFTextControl(text, (EStructuralFeature)DeployFilePackage.eINSTANCE.getRoot_Name());
        label = toolkit.createLabel(container, LABEL_DESCRIPTION);
        gd = new GridData(2);
        label.setLayoutData((Object)gd);
        text = toolkit.createText(container, null, 578);
        gd = new GridData(1808);
        gd.heightHint = text.getLineHeight() * 5;
        text.setLayoutData((Object)gd);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralInfoSection.this.handleDescriptionModified();
            }
        });
        this.mDescText = new EMFTextControl(text, (EStructuralFeature)DeployFilePackage.eINSTANCE.getRoot_Description());
        this.getSection().setClient((Control)container);
        toolkit.paintBordersFor(container);
    }

    protected void helpActivated(HyperlinkEvent event) {
        HelpUtilities.displayHelp((String)IHelpConstants.CONTEXT_ID_OVERVIEW_PAGE_OVERVIEW_SECTION);
    }

    protected void setModelRoot(EObject modelRoot) {
        if (modelRoot instanceof Root) {
            this.mRoot = (Root)modelRoot;
            this.initControls();
        }
    }

    private void initControls() {
        this.mNameText.setOwner((EObject)this.mRoot);
        this.mDescText.setOwner((EObject)this.mRoot);
    }

    private void handleNameModified() {
        String text = this.mNameText.getText();
        if (!text.equals(this.mRoot.getName())) {
            EditingDomain editingDomain = this.getResourceEditingContainer().getEditingDomain();
            Command setCommand = SetCommand.create((EditingDomain)editingDomain, (Object)this.mRoot, (Object)DeployFilePackage.eINSTANCE.getRoot_Name(), (Object)text);
            editingDomain.getCommandStack().execute(setCommand);
        }
    }

    private void handleDescriptionModified() {
        String text = this.mDescText.getText();
        if (!text.equals(this.mRoot.getDescription())) {
            EditingDomain editingDomain = this.getResourceEditingContainer().getEditingDomain();
            Command setCommand = SetCommand.create((EditingDomain)editingDomain, (Object)this.mRoot, (Object)DeployFilePackage.eINSTANCE.getRoot_Description(), (Object)text);
            editingDomain.getCommandStack().execute(setCommand);
        }
    }
}

