/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.emf.editors;

import java.io.IOException;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stp.soas.internal.deploy.emf.EMFCommonPlugin;
import org.eclipse.stp.soas.internal.deploy.emf.editors.IResourceEditingContainer;
import org.eclipse.stp.soas.internal.deploy.emf.refactoring.ResourceNameChangeAdapter;
import org.eclipse.stp.soas.internal.deploy.ui.editors.EnhancedFormEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public abstract class EMFFormEditor
extends EnhancedFormEditor
implements IResourceEditingContainer,
IResourceChangeListener {
    private AdapterFactoryEditingDomain mEditingDomain;
    private Resource mResource;
    private IPropertySheetPage mPropertySheetPage;
    private ResourceNameChangeAdapter mResourceURIUpdater;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!this.isValidContentType(input)) {
            Status s = new Status(4, EMFCommonPlugin.getDefault().getBundle().getSymbolicName(), 4, "Wrong editor for " + input.getName(), null);
            throw new PartInitException((IStatus)s);
        }
        super.init(site, input);
        try {
            this.initializeResource(input);
        }
        catch (CoreException e) {
            throw new PartInitException(e.getStatus());
        }
        this.setPartName(input.getName());
        if (input instanceof IFileEditorInput) {
            ((IFileEditorInput)input).getFile().getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public boolean isDirty() {
        return super.isDirty() || ((BasicCommandStack)this.getEditingDomain().getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    EMFFormEditor.this.getResource().save(EMFFormEditor.this.getSaveOptions());
                }
                catch (Exception exception) {
                    EMFCommonPlugin.getDefault().log(exception);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.getEditingDomain().getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            EMFCommonPlugin.getDefault().log(exception);
        }
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.mResource.setURI(URI.createPlatformResourceURI((String)file.getFullPath().toString()));
            FileEditorInput modelFile = new FileEditorInput(file);
            this.setInput((IEditorInput)modelFile);
            this.setPartName(file.getName());
            this.doSave(this.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor());
        }
    }

    public void dispose() {
        for (Resource resource : this.getEditingDomain().getResourceSet().getResources()) {
            if (!resource.isLoaded()) continue;
            try {
                resource.unload();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getEditingDomain().getResourceSet().getResources().clear();
        this.mEditingDomain.getResourceSet().eAdapters().remove((Object)this.mResourceURIUpdater);
        this.mResourceURIUpdater.dispose();
        this.mResourceURIUpdater = null;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public EditingDomain getEditingDomain() {
        return this.mEditingDomain;
    }

    public Resource getResource() {
        return this.mResource;
    }

    public EObject getModelRoot() {
        return (EObject)this.mResource.getContents().get(0);
    }

    protected boolean isValidContentType(IEditorInput input) {
        return true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) {
                        IResource resource = delta.getResource();
                        if (resource != null && resource instanceof IFile) {
                            IFile rem = (IFile)resource;
                            IEditorInput thisf = EMFFormEditor.this.getEditorInput();
                            Object f = thisf.getAdapter(IFile.class);
                            if (rem.equals(f)) {
                                if (delta.getKind() == 2) {
                                    if ((0x2000 & delta.getFlags()) != 0) {
                                        final IPath path = delta.getMovedToPath();
                                        Display display = EMFFormEditor.this.getSite().getShell().getDisplay();
                                        display.asyncExec(new Runnable(){

                                            public void run() {
                                                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                                                EMFFormEditor.this.setInput((IEditorInput)new FileEditorInput(file));
                                                EMFFormEditor.this.setPartName(path.lastSegment());
                                            }
                                        });
                                    } else {
                                        EMFFormEditor.this.close(EMFFormEditor.this.isSaveOnCloseNeeded());
                                    }
                                }
                                return false;
                            }
                            return true;
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected BasicCommandStack createCommandStack() {
        return new BasicCommandStack();
    }

    protected abstract AdapterFactory createModelAdapterFactory();

    protected AdapterFactory getModelAdapterFactory() {
        return ((AdapterFactoryEditingDomain)this.getEditingDomain()).getAdapterFactory();
    }

    protected AdapterFactoryEditingDomain createEditingDomain() {
        return new AdapterFactoryEditingDomain(this.createModelAdapterFactory(), (CommandStack)this.createCommandStack());
    }

    protected Map getLoadOptions() {
        return Collections.EMPTY_MAP;
    }

    protected Map getSaveOptions() {
        return Collections.EMPTY_MAP;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.mPropertySheetPage == null) {
            this.mPropertySheetPage = this.createPropertySheetPage();
        }
        return this.mPropertySheetPage;
    }

    protected IPropertySheetPage createPropertySheetPage() {
        PropertySheetPage propertySheet = new PropertySheetPage(){

            public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                super.makeContributions(menuManager, toolBarManager, statusLineManager);
            }

            public void setActionBars(IActionBars actionBars) {
                super.setActionBars(actionBars);
            }
        };
        propertySheet.setPropertySourceProvider(this.createPropertySourceProvider());
        return propertySheet;
    }

    protected IPropertySourceProvider createPropertySourceProvider() {
        return new AdapterFactoryContentProvider(this.getModelAdapterFactory());
    }

    protected void initializeResource(IEditorInput input) throws CoreException {
        this.mEditingDomain = this.createEditingDomain();
        this.mResourceURIUpdater = new ResourceNameChangeAdapter();
        this.mEditingDomain.getResourceSet().eAdapters().add((Object)this.mResourceURIUpdater);
        if (input instanceof IFileEditorInput) {
            IFile file = (IFile)input.getAdapter(IFile.class);
            if (file != null) {
                URI inputURI = URI.createPlatformResourceURI((String)file.getFullPath().toString());
                this.mResource = this.mEditingDomain.createResource(inputURI.toString());
                try {
                    this.mResource.load(this.getLoadOptions());
                }
                catch (IOException e) {
                    Status s = new Status(4, EMFCommonPlugin.getDefault().getBundle().getSymbolicName(), 4, "Error loading file " + input.getClass(), (Throwable)e);
                    throw new CoreException((IStatus)s);
                }
            }
        } else if (input instanceof IStorageEditorInput) {
            URI inputURI = URI.createGenericURI((String)"unknown", (String)input.getClass().toString(), (String)input.getName());
            this.mResource = this.mEditingDomain.createResource(inputURI.toString());
            try {
                this.mResource.load(((IStorageEditorInput)input).getStorage().getContents(), this.getLoadOptions());
            }
            catch (IOException e) {
                Status s = new Status(4, EMFCommonPlugin.getDefault().getBundle().getSymbolicName(), 4, "Error loading file " + input.getClass(), (Throwable)e);
                throw new CoreException((IStatus)s);
            }
        } else {
            Status s = new Status(4, EMFCommonPlugin.getDefault().getBundle().getSymbolicName(), 4, "Unkown input type " + input.getClass(), null);
            throw new CoreException((IStatus)s);
        }
        this.mEditingDomain.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                if (EMFFormEditor.this.getContainer() == null) {
                    EMFFormEditor.this.handleCommandStackChanged(event);
                } else {
                    EMFFormEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            EMFFormEditor.this.handleCommandStackChanged(event);
                        }
                    });
                }
            }
        });
    }

    protected void handleCommandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
        if (mostRecentCommand != null && this.getActivePageInstance() != null) {
            this.getActivePageInstance().selectReveal((Object)mostRecentCommand.getAffectedObjects());
        }
    }
}

