/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipes.stp.soas.deploy.runtime.cxf.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.eclipes.stp.soas.deploy.runtime.cxf.CxfRuntimePlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

/**
 * version hander for CXF 2.0
 * 
 * @author jma
 *
 */
public class Cxf20VersionHandler implements ICxfVersionHandler {

	private static String FACADED_JAR_NAME = "cxf-manifest-incubator.jar";
	private static String LIB_DIR_NAME = "lib";
//    private static String KIT_ROOT_DIR ="KIT_ROOT_DIR";
	
	/**
	 * get the classpath defined from cxf facade jar 
	 */
	public List<IRuntimeClasspathEntry> getRuntimeClasspath(IPath installPath) {
        List<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>();
        String libPath = installPath.append(LIB_DIR_NAME).makeAbsolute().toOSString();
        
        String filePath = libPath + File.separator + FACADED_JAR_NAME;
        String[] jars = RuntimeUtils.getLibEntryInManifest(filePath);
        for (String libName : jars) {
            IPath path = installPath.append(LIB_DIR_NAME).append(libName);            
            //we need to check the jar exists before add to classpath entry
            //for some cxf version, the jar referenced in manifest is invalid
            if (path.toFile().exists()) {
                cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry(path));
            }
        }
        return cp;
	}
	
	
	public boolean verifyInstallPath(IPath installPath) {
		if (installPath == null)
			return false;

		return CxfRuntimePlugin.verifyInstallPath(installPath);
	}
	
	

}
