/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipes.stp.soas.deploy.runtime.cxf.internal.simplefrontend;

import java.io.ByteArrayInputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IServiceDescriptorExtension;
import org.eclipse.stp.soas.deploy.core.IPackageExtension;
import org.eclipse.stp.soas.deploy.core.ServiceDescriptorBase;
import org.eclipse.stp.soas.deploy.core.Version;

public class SimpleServiceDescriptor extends ServiceDescriptorBase implements IExecutableExtension {

	public  static final String WSDL_FOLDER_STUB = "simple_frontend";
	private IFile mFile;
	private IProject project;
	
	@Override
	protected Version getTechnologyVersion() {
		//return Servlet version used by cxf
		return new Version(2, 1, 0, new String());
	}

	public String getDescription() {
		return "Servlet War";
	}

	@Override
	protected Version getRuntimeVersion() {
		return new Version(2, 1, 0, new String());
	}
	
	public IFile getFile(){
		return mFile;
	}
	
	public IPackageExtension getExtension() {
		IServiceDescriptorExtension ilpe = null;
		String extensionID = null;
		extensionID = "org.eclipse.stp.sc.cxf.buildpackage.SimpleLogicalPackage";
		if (extensionID != null) {
			ilpe = DeploymentExtensionManager.getInstance().getLogicalPackageExtension(extensionID);
		}
		return ilpe;
	}
	
	public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException{
		//do nothing
	}

	public void init(IPackageExtension extension, IFile pkg) {
		super.init(extension, pkg);
		setProject(pkg.getProject());

	}
	
	public void setProject(IProject project){
		this.project = project;
		try{
			IFolder wsdlFolderStub = (IFolder)JaxWsWorkspaceManager.getWSDLFolder(this.project);;
			if(!wsdlFolderStub.exists()){
				wsdlFolderStub.create(true, true, null);
			}
			mFile = wsdlFolderStub.getFile(project.getName() + ".simple");
			if(!mFile.exists()){
				mFile.create(new ByteArrayInputStream(new byte[0]), true, null);
			}
		}catch(Exception ex){
			ex.printStackTrace();
		}
	}
	

}
