/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * @author rcernich
 * 
 * Created on Jul 19, 2004
 */
public class FilePackageOutputDescriptor extends PackageOutputDescriptor {

	private File mFile;

	public FilePackageOutputDescriptor(File file,
										ITechnologyType technologyType,
										IServerType serverType,
										String fileName, String logicalName) {
		super(technologyType, serverType, fileName, logicalName);
		mFile = file;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.PackageOutputDescriptor#createInputStream()
	 */
	public InputStream createInputStream() throws IOException {
		return new FileInputStream(mFile);
	}

	public File getFile() {
		return mFile;
	}

}