/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.wst.server.core.IServer;

/**
 * This interface is used to represent an actual deployment target.  The target
 * is identified by the connection profile associated with this object.  This
 * interface mainly serves to append information to an IConnectionProfile
 * object that is required by the deployment framework.
 *  
 * @author rcernich
 *
 * Created on Apr 6, 2004
 */
public interface IDeployTarget {

	/**
	 * Uses the minimum version, maximum version, and match rule information
	 * associated with this extension to determine whether or not a server may
	 * supported by this driver.
	 * 
	 * @param type the type of server
	 * 
	 * @return true if this driver provides support for the specified server and
	 * version.
	 */
	boolean supportsServer(IServerType serverType);
	
	/**
	 * @return the connection profile representing this target.
	 */
	IServer getServer();

}
