package org.eclipse.stp.soas.deploy.core;

public class RuntimeType implements IRuntimeType {

	private String mRuntimeDef;
	private IVersion mVersion;

	public RuntimeType(String runtimeDef, IVersion version) {
		super();
		if (DeploymentExtensionManager.getInstance().getRuntimeDefinition(
				runtimeDef) == null) {
			throw new IllegalArgumentException(
					DeployCorePlugin
							.getDefault()
							.getResourceString(
									"RuntimeType.exception.serverDefinitionDoesNotExist", //$NON-NLS-1$
									new Object[] { runtimeDef}));
		}
		mRuntimeDef = runtimeDef;
		mVersion = version;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IRuntimeType#getServerDefinition()
	 */
	public IRuntimeDefinition getRuntimeDefinition() {
		return DeploymentExtensionManager.getInstance().getRuntimeDefinition(
				mRuntimeDef);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IRuntimeType#getVersion()
	 */
	public IVersion getVersion() {
		return mVersion;
	}

	public String toString() {
		return DeployCorePlugin.getDefault().getResourceString(
				"RuntimeType.toString", new Object[] { mRuntimeDef, mVersion}); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		boolean retVal;
		if (this == obj) {
			retVal = true;
		}
		else if (obj instanceof RuntimeType) {
			RuntimeType st = (RuntimeType) obj;
			retVal = mRuntimeDef.equals(st.mRuntimeDef)
					&& mVersion.equals(st.mVersion);
		}
		else {
			retVal = false;
		}
		return retVal;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		// Could do better, but this should work.
		return mRuntimeDef.hashCode();
	}

}
