/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core.wtpbridge;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stp.soas.deploy.core.adapters.IWTPServerAdapter;

/**
 * @author jma
 *
 */
public class WtpBridgeExtension {
	private final static String WTP_ADAPTER_CLASS = "serverAdapterClass";
    String serverType;
    String connectionProfileID;
    IConfigurationElement config;
    
    public WtpBridgeExtension() {
    	
    }
    
    public WtpBridgeExtension(String type, String id, IConfigurationElement cfg) {
    	serverType = type;
    	connectionProfileID = id;
    	config = cfg;
    }
    
    public IWTPServerAdapter createServerAdatper() throws CoreException {
    	return (IWTPServerAdapter)config.createExecutableExtension(WTP_ADAPTER_CLASS);
    }
    
}
