/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.stp.soas.deploy.models.deployfile.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.stp.soas.deploy.models.deployfile.*;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFileFactory;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class DeployFileFactoryImpl extends EFactoryImpl implements
		DeployFileFactory {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "(c) 2004 Sybase, Inc.";

	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static DeployFileFactory init() {
		try {
			DeployFileFactory theDeployFileFactory = (DeployFileFactory) EPackage.Registry.INSTANCE
					.getEFactory("http://www.eclipse.org/stp/models/deploy/deployfile");
			if (theDeployFileFactory != null) {
				return theDeployFileFactory;
			}
		} catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new DeployFileFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeployFileFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
		case DeployFilePackage.DEPLOY_PACKAGE:
			return createDeployPackage();
		case DeployFilePackage.DEPLOY_CONFIGURATION:
			return createDeployConfiguration();
		case DeployFilePackage.DEPLOY_SERVER:
			return createDeployServer();
		case DeployFilePackage.ROOT:
			return createRoot();
		default:
			throw new IllegalArgumentException("The class '" + eClass.getName()
					+ "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeployPackage createDeployPackage() {
		DeployPackageImpl deployPackage = new DeployPackageImpl();
		return deployPackage;
	}

	/**
	 * @generated NOT
	 */
	public DeployPackage createDeployPackage(String file) {
		DeployPackage dp = createDeployPackage();
		dp.setPackageFile(file);
		return dp;
	}

	/**
	 * @generated NOT
	 */
	public DeployPackage createDeployPackage(Root root, String file) {
		DeployPackage dp = createDeployPackage(file);
		dp.setRoot(root);
		return dp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeployConfiguration createDeployConfiguration() {
		DeployConfigurationImpl deployConfiguration = new DeployConfigurationImpl();
		return deployConfiguration;
	}

	/**
	 * @generated NOT
	 */
	public DeployConfiguration createDeployConfiguration(DeployServer target) {
		DeployConfiguration dc = createDeployConfiguration();
		dc.setTargetServer(target);
		return dc;
	}

	/**
	 * @generated NOT
	 */
	public DeployConfiguration createDeployConfiguration(DeployServer target,
			DeployPackage container) {
		DeployConfiguration dc = createDeployConfiguration(target);
		dc.setSourcePackage(container);
		return dc;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeployServer createDeployServer() {
		DeployServerImpl deployServer = new DeployServerImpl();
		return deployServer;
	}

	/**
	 * @generated NOT
	 */
	public DeployServer createDeployServer(String file) {
		DeployServer ds = createDeployServer();
		ds.setProfileName(file);
		return ds;
	}

	/**
	 * @generated NOT
	 */
	public DeployServer createDeployServer(String file, Root root) {
		DeployServer ds = createDeployServer(file);
		ds.setRoot(root);
		return ds;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Root createRoot() {
		RootImpl root = new RootImpl();
		return root;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeployFilePackage getDeployFilePackage() {
		return (DeployFilePackage) getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static DeployFilePackage getPackage() {
		return DeployFilePackage.eINSTANCE;
	}

} //DeployFileFactoryImpl
