/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.actions.AbstractGroupUngroupAction;
import org.eclipse.stp.bpmn.diagram.actions.GroupInSubprocessCommand;
import org.eclipse.stp.bpmn.diagram.edit.parts.Activity2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.LaneEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBorderCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditDomain;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupAction
extends AbstractGroupUngroupAction {
    public static final String ACTION_ID = "groupAction";
    public static final String TOOLBAR_ACTION_ID = "toolbarGroupAction";
    protected static final String ICON_PATH = "icons/Group.gif";
    protected static final String ACTION_TEXT = BpmnDiagramMessages.GroupAction_label;
    protected static final String TOOLTIP_TEXT = BpmnDiagramMessages.GroupAction_tooltip;
    private Set<GraphicalEditPart> editParts = new HashSet<GraphicalEditPart>();
    private List<IGraphicalEditPart> almostSelectedBoundaryEvents = new ArrayList<IGraphicalEditPart>();
    private Collection<SequenceEdgeEditPart> externalSrcConnections = new ArrayList<SequenceEdgeEditPart>();
    private Collection<SequenceEdgeEditPart> externalTgtConnections = new ArrayList<SequenceEdgeEditPart>();
    private Collection<SequenceEdgeEditPart> internalConnections = new HashSet<SequenceEdgeEditPart>();

    public GroupAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public GroupAction(IWorkbenchPart workbenchPart) {
        super(workbenchPart);
    }

    private static GroupAction createActionWithoutId(IWorkbenchPage workbenchPage) {
        GroupAction action = new GroupAction(workbenchPage);
        action.setText(ACTION_TEXT);
        action.setToolTipText(TOOLTIP_TEXT);
        action.setImageDescriptor(BpmnDiagramEditorPlugin.getBundledImageDescriptor(ICON_PATH));
        return action;
    }

    public static GroupAction createGroupAction(IWorkbenchPage workbenchPage) {
        GroupAction action = GroupAction.createActionWithoutId(workbenchPage);
        action.setId(ACTION_ID);
        return action;
    }

    public static GroupAction createToolbarGroupAction(IWorkbenchPage workbenchPage) {
        GroupAction action = GroupAction.createActionWithoutId(workbenchPage);
        action.setId(TOOLBAR_ACTION_ID);
        return action;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        IGraphicalEditPart firstEditPart = (IGraphicalEditPart)this.editParts.iterator().next();
        GroupInSubprocessCommand groupCommand = new GroupInSubprocessCommand(firstEditPart.getEditingDomain(), this.editParts, this.almostSelectedBoundaryEvents, this.externalSrcConnections, this.externalTgtConnections, this.internalConnections);
        firstEditPart.getDiagramEditDomain().getDiagramCommandStack().execute((Command)new ICommandProxy((ICommand)groupCommand));
    }

    public void refresh() {
        IStructuredSelection strSelection = this.getStructuredSelection();
        GroupAction.refresh((Action)this, strSelection, this.editParts, this.almostSelectedBoundaryEvents, this.externalSrcConnections, this.externalTgtConnections, this.internalConnections);
    }

    static void refresh(Action action, IStructuredSelection strSelection, Set<GraphicalEditPart> editParts, List<IGraphicalEditPart> almostSelectedBoundaryEvents, Collection<SequenceEdgeEditPart> externalSrcConnections, Collection<SequenceEdgeEditPart> externalTgtConnections, Collection<SequenceEdgeEditPart> internalConnections) {
        EditPart currElement;
        editParts.clear();
        almostSelectedBoundaryEvents.clear();
        internalConnections.clear();
        externalSrcConnections.clear();
        externalTgtConnections.clear();
        for (Object editPart : strSelection.toList()) {
            if (!(editPart instanceof GraphicalEditPart) || editPart instanceof Activity2EditPart || editPart instanceof ITextAwareEditPart) continue;
            editParts.add((GraphicalEditPart)editPart);
        }
        EditPart parentContainer = null;
        Iterator<GraphicalEditPart> iterator = editParts.iterator();
        boolean onlyArtifacts = true;
        while (iterator.hasNext()) {
            GraphicalEditPart editPart = iterator.next();
            EditPart container = editPart.getParent();
            if (editPart.resolveSemanticElement() instanceof Artifact) continue;
            onlyArtifacts = false;
            if (editPart instanceof LaneEditPart || !(container instanceof PoolPoolCompartmentEditPart) && !(container instanceof SubProcessSubProcessBodyCompartmentEditPart)) {
                editParts.clear();
                almostSelectedBoundaryEvents.clear();
                break;
            }
            if (container instanceof SubProcessSubProcessBodyCompartmentEditPart && GroupAction.isInsideAnother(container, editParts)) {
                iterator.remove();
                continue;
            }
            if (editPart instanceof SubProcessEditPart) {
                SubProcessSubProcessBorderCompartmentEditPart borderEditPart = (SubProcessSubProcessBorderCompartmentEditPart)((SubProcessEditPart)editPart).getChildBySemanticHintOnPrimaryView("5003");
                for (Object child : borderEditPart.getChildren()) {
                    if (!(child instanceof Activity2EditPart)) continue;
                    almostSelectedBoundaryEvents.add((IGraphicalEditPart)child);
                }
            }
            if (parentContainer == null) {
                parentContainer = container;
                continue;
            }
            if (parentContainer == container) continue;
            editParts.clear();
            almostSelectedBoundaryEvents.clear();
            break;
        }
        if (onlyArtifacts) {
            editParts.clear();
        }
        for (GraphicalEditPart editPart : editParts) {
            GroupAction.sortConnections((IGraphicalEditPart)editPart, editParts, almostSelectedBoundaryEvents, internalConnections, externalSrcConnections, externalTgtConnections);
        }
        EditPart element = null;
        for (SequenceEdgeEditPart connection : externalSrcConnections) {
            currElement = connection.getSource();
            if (element == null) {
                element = currElement;
                continue;
            }
            if (element == currElement) continue;
            if (action != null) {
                action.setEnabled(false);
            }
            return;
        }
        element = null;
        for (SequenceEdgeEditPart connection : externalTgtConnections) {
            currElement = connection.getTarget();
            if (element == null) {
                element = currElement;
                continue;
            }
            if (element == currElement) continue;
            if (action != null) {
                action.setEnabled(false);
            }
            return;
        }
        for (GraphicalEditPart editPart : editParts) {
            if (!GroupAction.lookForIgnoredSequenceMembers(editPart, editParts, false, new HashSet<EditPart>())) continue;
            editParts.clear();
            break;
        }
        for (GraphicalEditPart editPart : editParts) {
            if (!(editPart instanceof IGraphicalEditPart) || !(editPart.resolveSemanticElement() instanceof Activity) || !ActivityType.VALUES_GATEWAYS.contains(((Activity)editPart.resolveSemanticElement()).getActivityType()) || !GroupAction.lookForIgnoredGatewayBranch(editPart, editParts)) continue;
            editParts.clear();
            break;
        }
        if (action != null) {
            action.setEnabled(!editParts.isEmpty());
        }
    }

    private static boolean lookForIgnoredGatewayBranch(GraphicalEditPart editPart, Set<GraphicalEditPart> editParts) {
        boolean isMerge = false;
        Activity gateway = (Activity)editPart.resolveSemanticElement();
        if (gateway.getIncomingEdges().size() > 1) {
            isMerge = true;
        } else if (gateway.getOutgoingEdges().size() > 1) {
            isMerge = false;
        } else {
            return false;
        }
        ArrayList<EditPart> eps = new ArrayList<EditPart>();
        if (isMerge) {
            for (Object ep : editPart.getTargetConnections()) {
                if (!(ep instanceof SequenceEdgeEditPart)) continue;
                eps.add(((SequenceEdgeEditPart)((Object)ep)).getSource());
            }
        } else {
            for (Object ep : editPart.getSourceConnections()) {
                if (!(ep instanceof SequenceEdgeEditPart)) continue;
                eps.add(((SequenceEdgeEditPart)((Object)ep)).getTarget());
            }
        }
        boolean oneSelected = false;
        boolean oneNotSelected = false;
        for (Object e : eps) {
            if (editParts.contains(e)) {
                oneSelected = true;
                continue;
            }
            oneNotSelected = true;
        }
        return oneSelected && oneNotSelected;
    }

    static void sortConnections(IGraphicalEditPart editPart, Set<GraphicalEditPart> editParts, List<IGraphicalEditPart> almostSelectedBoundaryEvents, Collection<SequenceEdgeEditPart> internalConnections, Collection<SequenceEdgeEditPart> externalSrcConnection, Collection<SequenceEdgeEditPart> externalTgtConnections) {
        List srcConnections = editPart.getSourceConnections();
        for (Object connection : srcConnections) {
            if (!(connection instanceof SequenceEdgeEditPart)) continue;
            SequenceEdgeEditPart sequenceConnection = (SequenceEdgeEditPart)((Object)connection);
            if (editParts.contains(sequenceConnection.getTarget()) || almostSelectedBoundaryEvents.contains(sequenceConnection.getTarget())) {
                internalConnections.add(sequenceConnection);
                continue;
            }
            externalSrcConnection.add(sequenceConnection);
        }
        List targetConnections = editPart.getTargetConnections();
        for (Object connection : targetConnections) {
            if (!(connection instanceof SequenceEdgeEditPart)) continue;
            SequenceEdgeEditPart sequenceConnection = (SequenceEdgeEditPart)((Object)connection);
            if (editParts.contains(sequenceConnection.getSource()) || almostSelectedBoundaryEvents.contains(sequenceConnection.getSource())) {
                internalConnections.add(sequenceConnection);
                continue;
            }
            externalTgtConnections.add(sequenceConnection);
        }
    }

    static boolean lookForIgnoredSequenceMembers(GraphicalEditPart editPart, Set<GraphicalEditPart> editParts, boolean metIgnoredShapes, Set<EditPart> visited) {
        visited.add((EditPart)editPart);
        boolean foundIgnored = false;
        for (Object connection : editPart.getTargetConnections()) {
            if (!(connection instanceof SequenceEdgeEditPart)) continue;
            GraphicalEditPart part = (GraphicalEditPart)((ConnectionEditPart)connection).getSource();
            if (editParts.contains(part)) {
                if (metIgnoredShapes) {
                    return true;
                }
            } else {
                metIgnoredShapes = true;
            }
            if (visited.contains(part)) {
                return false;
            }
            boolean bl = foundIgnored = foundIgnored || GroupAction.lookForIgnoredSequenceMembers(part, editParts, metIgnoredShapes, visited);
        }
        return foundIgnored;
    }

    private static boolean isInsideAnother(EditPart editPart, Set<GraphicalEditPart> editParts) {
        SubProcessEditPart subProcess = GroupAction.getSubProcess(editPart);
        while (subProcess != null) {
            if (editParts.contains((Object)subProcess)) {
                return true;
            }
            subProcess = GroupAction.getSubProcess(subProcess.getParent());
        }
        return false;
    }

    protected ISelection getSelection() {
        IStructuredSelection structSel;
        ISelection sel = super.getSelection();
        if (sel != null && sel instanceof IStructuredSelection && (structSel = (IStructuredSelection)sel).getFirstElement() instanceof GraphicalEditPart) {
            BpmnDiagramEditDomain.IEditPartSelectionFilter filter = ((BpmnDiagramEditDomain)((GraphicalEditPart)structSel.getFirstElement()).getViewer().getEditDomain()).getActionSelectionFilter();
            if (filter == null) {
                return sel;
            }
            return filter.filterSelection(ACTION_ID, structSel);
        }
        return sel;
    }
}

