/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.generation.impl;

import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.Identifiable;
import org.eclipse.stp.bpmn.Lane;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.generation.IProcessGenerator;
import org.eclipse.stp.bpmn.diagram.generation.IVisualProcessGenerator;
import org.eclipse.stp.bpmn.diagram.generation.impl.BPMNProcessGenerator;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPMNVisualProcessGenerator
implements IVisualProcessGenerator {
    protected static final int POOL_INTERVAL = 16;
    protected static final int CONTAINER_INTERVAL = 10;
    private BPMNProcessGenerator _semanticGenerator;

    public BPMNVisualProcessGenerator() {
        this._semanticGenerator = new BPMNProcessGenerator();
    }

    public BPMNVisualProcessGenerator(Diagram diagram) {
        this._semanticGenerator = new BPMNProcessGenerator(diagram);
    }

    public BPMNVisualProcessGenerator(IPath path) {
        this._semanticGenerator = new BPMNProcessGenerator(path);
    }

    public IProcessGenerator getSemanticGenerator() {
        return this._semanticGenerator;
    }

    @Override
    public Node addActivity(Node parent, String name, int activityType, int x, int y, int width, int height) {
        Node view = this.addActivity(parent, name, activityType);
        this.setCoordinates((View)view, x, y, width, height);
        return view;
    }

    @Override
    public Node addLane(Node pool, String name, int x, int y, int width, int height) {
        Node view = this.addLane(pool, name);
        this.setCoordinates((View)view, x, y, width, height);
        return view;
    }

    @Override
    public Node addPool(String name, int x, int y, int width, int height) {
        Node view = this.addPool(name);
        this.setCoordinates((View)view, x, y, width, height);
        return view;
    }

    protected void setCoordinates(final View view, int x, int y, int width, int height) {
        final Bounds bounds = NotationFactory.eINSTANCE.createBounds();
        bounds.setX(x);
        bounds.setY(y);
        bounds.setWidth(width);
        bounds.setHeight(height);
        if (!(view instanceof Node)) {
            throw new IllegalArgumentException("This view isn't a node, how do I set its coordinates ?" + view);
        }
        BPMNProcessGenerator bPMNProcessGenerator = this._semanticGenerator;
        bPMNProcessGenerator.getClass();
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(bPMNProcessGenerator){

            protected void doExecute() {
                ((Node)view).setLayoutConstraint((LayoutConstraint)bounds);
            }
        };
        this._semanticGenerator._editingDomain.getCommandStack().execute((Command)command);
    }

    @Override
    public Node addPool(String name) {
        final Pool p = this._semanticGenerator.addPool(name);
        BPMNProcessGenerator bPMNProcessGenerator = this._semanticGenerator;
        bPMNProcessGenerator.getClass();
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(bPMNProcessGenerator){

            protected void doExecute() {
                String semanticHints = BpmnVisualIDRegistry.getType(1001);
                Node poolNotationNode = ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter((EObject)p), (View)BPMNVisualProcessGenerator.this._semanticGenerator.getGraphicalModel(), semanticHints, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                this.setReturnedObject((EObject)poolNotationNode);
            }
        };
        this._semanticGenerator._editingDomain.getCommandStack().execute((Command)command);
        return (Node)command.getReturnedObject();
    }

    @Override
    public Node addLane(Node pool, String name) {
        final Lane l = this._semanticGenerator.addLane((Pool)pool.getElement(), name);
        BPMNProcessGenerator bPMNProcessGenerator = this._semanticGenerator;
        bPMNProcessGenerator.getClass();
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(bPMNProcessGenerator){

            protected void doExecute() {
                String semanticHints = BpmnVisualIDRegistry.getType(2007);
                Node laneNotationNode = ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter((EObject)l), (View)BPMNVisualProcessGenerator.this._semanticGenerator.getGraphicalModel(), semanticHints, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                this.setReturnedObject((EObject)laneNotationNode);
            }
        };
        this._semanticGenerator._editingDomain.getCommandStack().execute((Command)command);
        return (Node)command.getReturnedObject();
    }

    @Override
    public Node addActivity(Node poolOrSubProcess, String name, int activityType) {
        final Activity activity = this._semanticGenerator.addActivity((Graph)poolOrSubProcess.getElement(), name, activityType);
        Node tempParent = null;
        for (Object child : poolOrSubProcess.getChildren()) {
            if (child instanceof Node && String.valueOf(5001).equals(String.valueOf(((Node)child).getType()))) {
                tempParent = (Node)child;
                continue;
            }
            if (!(child instanceof Node) || !String.valueOf(5002).equals(String.valueOf(((Node)child).getType()))) continue;
            tempParent = (Node)child;
        }
        if (tempParent == null) {
            throw new IllegalArgumentException("Unable to find the compartment view for this graph " + poolOrSubProcess);
        }
        final Node parent = tempParent;
        BPMNProcessGenerator bPMNProcessGenerator = this._semanticGenerator;
        bPMNProcessGenerator.getClass();
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(bPMNProcessGenerator){

            protected void doExecute() {
                if (activity.getActivityType().getValue() != 1) {
                    String semanticHints2 = BpmnVisualIDRegistry.getType(2001);
                    Node aNode = ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter((EObject)activity), (View)parent, semanticHints2, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                    this.setReturnedObject((EObject)aNode);
                } else {
                    String semanticHintsForSP = BpmnVisualIDRegistry.getType(2002);
                    Node aNode = ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter((EObject)activity), (View)parent, semanticHintsForSP, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                    this.setReturnedObject((EObject)aNode);
                }
            }
        };
        this._semanticGenerator._editingDomain.getCommandStack().execute((Command)command);
        return (Node)command.getReturnedObject();
    }

    @Override
    public void addDocumentation(View element, String documentation) {
        this._semanticGenerator.addDocumentation((Identifiable)element.getElement(), documentation);
    }

    @Override
    public EAnnotation addAnnotation(View view, String source, Map<String, String> details) {
        return this._semanticGenerator.addAnnotation((EModelElement)view.getElement(), source, details);
    }

    @Override
    public Edge addSequenceEdge(final Node source, final Node target, String name) {
        final SequenceEdge seqEdge = this._semanticGenerator.addSequenceEdge((Vertex)source.getElement(), (Vertex)target.getElement(), name);
        BPMNProcessGenerator bPMNProcessGenerator = this._semanticGenerator;
        bPMNProcessGenerator.getClass();
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(bPMNProcessGenerator){

            protected void doExecute() {
                String semanticHints = BpmnVisualIDRegistry.getType(3001);
                Edge anEdge = (Edge)ViewService.getInstance().createEdge((IAdaptable)new EObjectAdapter((EObject)seqEdge), (View)BPMNVisualProcessGenerator.this._semanticGenerator.getGraphicalModel(), semanticHints, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                anEdge.setSource((View)source);
                anEdge.setTarget((View)target);
                this.setReturnedObject((EObject)anEdge);
            }
        };
        this._semanticGenerator._editingDomain.getCommandStack().execute((Command)command);
        return (Edge)command.getReturnedObject();
    }

    @Override
    public Edge addMessagingEdge(final Node source, final Node target, String name) {
        final MessagingEdge edge = this._semanticGenerator.messageConnect((Activity)source.getElement(), (Activity)target.getElement(), name);
        BPMNProcessGenerator bPMNProcessGenerator = this._semanticGenerator;
        bPMNProcessGenerator.getClass();
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(bPMNProcessGenerator){

            protected void doExecute() {
                String semanticHints = BpmnVisualIDRegistry.getType(3002);
                Edge anEdge = (Edge)ViewService.getInstance().createEdge((IAdaptable)new EObjectAdapter((EObject)edge), (View)BPMNVisualProcessGenerator.this._semanticGenerator.getGraphicalModel(), semanticHints, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                anEdge.setSource((View)source);
                anEdge.setTarget((View)target);
                this.setReturnedObject((EObject)anEdge);
            }
        };
        this._semanticGenerator._editingDomain.getCommandStack().execute((Command)command);
        return (Edge)command.getReturnedObject();
    }

    @Override
    public Edge addSequenceOrMessagingEdge(Node source, Node target, String name) {
        if (((Vertex)source.getElement()).getGraph().equals(((Vertex)target.getElement()).getGraph())) {
            return this.addSequenceEdge(source, target, name);
        }
        return this.addMessagingEdge(source, target, name);
    }

    public void save() {
        this._semanticGenerator.save();
    }
}

