/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.part;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.util.IDEEditorUtil;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.util.DiagramFileCreator;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.BpmnFactory;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.generation.impl.BPMNVisual2ProcessGenerator;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class BpmnDiagramEditorUtil
extends IDEEditorUtil {
    public static IFile createAndOpenDiagram(DiagramFileCreator diagramFileCreator, IPath containerPath, String fileName, InputStream initialContents, String kind, IWorkbenchWindow window, IProgressMonitor progressMonitor, boolean openEditor, boolean saveDiagram) {
        IFile diagramFile = BpmnDiagramEditorUtil.createNewDiagramFile(diagramFileCreator, containerPath, fileName, initialContents, kind, window.getShell(), progressMonitor);
        return diagramFile;
    }

    public static IFile createNewDiagramFile(DiagramFileCreator diagramFileCreator, IPath containerFullPath, String fileName, InputStream initialContents, String kind, Shell shell, IProgressMonitor progressMonitor) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        progressMonitor.beginTask("Creating diagram and model files", 4);
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(progressMonitor, 1);
        final IFile diagramFile = diagramFileCreator.createNewFile(containerFullPath, fileName, initialContents, shell, new IRunnableContext((IProgressMonitor)subProgressMonitor){
            private final /* synthetic */ IProgressMonitor val$subProgressMonitor;
            {
                this.val$subProgressMonitor = iProgressMonitor;
            }

            public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                runnable.run(this.val$subProgressMonitor);
            }
        });
        final Resource diagramResource = resourceSet.createResource(URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString()));
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add(diagramFile);
        IPath modelFileRelativePath = diagramFile.getFullPath().removeFileExtension().addFileExtension("bpmn");
        IFile modelFile = diagramFile.getParent().getFile((IPath)new Path(modelFileRelativePath.lastSegment()));
        final Resource modelResource = resourceSet.createResource(URI.createPlatformResourceURI((String)modelFile.getFullPath().toString()));
        affectedFiles.add(modelFile);
        final String kindParam = kind;
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Creating diagram and model", affectedFiles){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                BpmnDiagram model = BpmnDiagramEditorUtil.createInitialModelGen();
                modelResource.getContents().add((Object)model);
                Diagram diagram = ViewService.createDiagram((EObject)model, (String)kindParam, (PreferencesHint)BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                diagramResource.getContents().add((Object)diagram);
                diagram.setName(diagramFile.getName());
                diagram.setElement((EObject)model);
                BPMNVisual2ProcessGenerator generator = new BPMNVisual2ProcessGenerator(diagram);
                Pool p = generator.addPool(BpmnDiagramMessages.BpmnDiagramEditorUtil_pool_default_name, 16, 16, 1500, 200);
                generator.addActivity((Graph)p, BpmnDiagramMessages.BpmnDiagramEditorUtil_task_default_name, 0, ActivityEditPart.ACTIVITY_FIGURE_SIZE.width / 2, 100 - ActivityEditPart.ACTIVITY_FIGURE_SIZE.height / 2, ActivityEditPart.ACTIVITY_FIGURE_SIZE.width, ActivityEditPart.ACTIVITY_FIGURE_SIZE.height);
                generator.generateViews();
                try {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("ENCODING", "UTF-8");
                    modelResource.save(options);
                    diagramResource.save(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    BpmnDiagramEditorPlugin.getInstance().logError("Unable to store model and diagram resources", e);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), null);
        }
        catch (ExecutionException e) {
            BpmnDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        try {
            modelFile.setCharset("UTF-8", (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        catch (CoreException e) {
            BpmnDiagramEditorPlugin.getInstance().logError("Unable to set charset for model file", e);
        }
        try {
            diagramFile.setCharset("UTF-8", (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        catch (CoreException e) {
            BpmnDiagramEditorPlugin.getInstance().logError("Unable to set charset for diagram file", e);
        }
        return diagramFile;
    }

    protected static BpmnDiagram createInitialModelGen() {
        return BpmnFactory.eINSTANCE.createBpmnDiagram();
    }

    protected static BpmnDiagram createInitialModel() {
        BpmnDiagram diagram = BpmnDiagramEditorUtil.createInitialModelGen();
        String author = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getString("diagramAuthor");
        if (author != null) {
            diagram.setAuthor(author);
        }
        Pool pool = BpmnFactory.eINSTANCE.createPool();
        pool.setName(BpmnDiagramMessages.BpmnDiagramEditorUtil_pool_default_name);
        diagram.getPools().add((Object)pool);
        Activity activity = BpmnFactory.eINSTANCE.createActivity();
        activity.setName(BpmnDiagramMessages.BpmnDiagramEditorUtil_task_default_name);
        pool.getVertices().add((Object)activity);
        return diagram;
    }

    private static void createPoolView(Diagram diagram) {
        BpmnDiagram model = (BpmnDiagram)diagram.getElement();
        String semanticHints = BpmnVisualIDRegistry.getType(1001);
        EList pools = model.getPools();
        if (!pools.isEmpty()) {
            Pool pool = (Pool)pools.iterator().next();
            Node poolNotationNode = ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter((EObject)pool), (View)diagram, semanticHints, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            Bounds bounds = NotationFactory.eINSTANCE.createBounds();
            bounds.setWidth(1500);
            bounds.setHeight(200);
            bounds.setX(16);
            bounds.setY(16);
            poolNotationNode.setLayoutConstraint((LayoutConstraint)bounds);
            if (!pool.getVertices().isEmpty()) {
                for (Object child : poolNotationNode.getChildren()) {
                    if (!(child instanceof Node) || !String.valueOf(5001).equals(String.valueOf(((Node)child).getType()))) continue;
                    String semanticHints2 = BpmnVisualIDRegistry.getType(2001);
                    Activity activity = (Activity)pool.getVertices().get(0);
                    Node aNode = ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter((EObject)activity), (View)((Node)child), semanticHints2, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                    Location loc = NotationFactory.eINSTANCE.createLocation();
                    loc.setX(ActivityEditPart.ACTIVITY_FIGURE_SIZE.width / 2);
                    loc.setY(100 - ActivityEditPart.ACTIVITY_FIGURE_SIZE.height / 2);
                    aNode.setLayoutConstraint((LayoutConstraint)loc);
                    break;
                }
            }
        }
    }

    protected static EObject createInitialRoot(BpmnDiagram model) {
        return model;
    }
}

