/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.ui.resources.FileChangeManager;
import org.eclipse.gmf.runtime.common.ui.resources.IFileObserver;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Identifiable;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditor;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramPreferenceInitializer;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.diagram.providers.BpmnDecorationFilterService;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class BpmnValidationDecoratorProvider
extends AbstractProvider
implements IDecoratorProvider {
    private static final String KEY = "validationStatus";
    private static final String MARKER_TYPE = "org.eclipse.stp.bpmn.validation.diagnostic";
    private static final String BPMN_ID = "bpmnId";
    private static final String ELEMENT_ID = "elementId";
    private static MarkerObserver fileObserver = null;

    private static EObject resolveSemanticElement(IDecoratorTarget decoratorTarget) {
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart != null && editPart instanceof IGraphicalEditPart) {
            EObject eobj = ((IGraphicalEditPart)editPart).resolveSemanticElement();
            return eobj;
        }
        return null;
    }

    public void createDecorators(IDecoratorTarget decoratorTarget) {
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart instanceof IGraphicalEditPart) {
            View view;
            Object model = editPart.getModel();
            if (model instanceof View && !((view = (View)model) instanceof Edge) && !view.isSetElement()) {
                return;
            }
            EditDomain ed = editPart.getViewer().getEditDomain();
            if (!(ed instanceof DiagramEditDomain)) {
                return;
            }
            if (((DiagramEditDomain)ed).getEditorPart() instanceof BpmnDiagramEditor) {
                decoratorTarget.installDecorator((Object)KEY, (IDecorator)new StatusDecorator(decoratorTarget));
            }
        }
    }

    public boolean provides(IOperation operation) {
        if (!(operation instanceof CreateDecoratorsOperation)) {
            return false;
        }
        IDecoratorTarget decoratorTarget = ((CreateDecoratorsOperation)operation).getDecoratorTarget();
        View view = (View)decoratorTarget.getAdapter(View.class);
        return view != null && BpmnDiagramEditPart.MODEL_ID.equals(BpmnVisualIDRegistry.getModelID(view));
    }

    static class MarkerObserver
    implements IFileObserver {
        private HashMap mapOfIdsToDecorators = null;
        private HashMap mapOfBpmnIdsToDecorators = null;
        private boolean isRegistered = false;
        private Diagram diagramView;

        private MarkerObserver(Diagram diagramView) {
            this.diagramView = diagramView;
        }

        private void registerDecorator(StatusDecorator decorator) {
            String decoratorViewId;
            if (decorator == null) {
                return;
            }
            if (this.mapOfIdsToDecorators == null) {
                this.mapOfIdsToDecorators = new HashMap();
                this.mapOfBpmnIdsToDecorators = new HashMap();
            }
            if ((decoratorViewId = decorator.getViewId()) == null) {
                return;
            }
            String bpmnId = decorator.getBpmnId();
            ArrayList<StatusDecorator> list = (ArrayList<StatusDecorator>)this.mapOfIdsToDecorators.get(decoratorViewId);
            if (list == null) {
                list = new ArrayList<StatusDecorator>(2);
                list.add(decorator);
                this.mapOfIdsToDecorators.put(decoratorViewId, list);
                if (bpmnId != null) {
                    this.mapOfBpmnIdsToDecorators.put(bpmnId, list);
                }
            } else if (!list.contains((Object)decorator)) {
                list.add(decorator);
            }
            if (!this.isRegistered()) {
                FileChangeManager.getInstance().addFileObserver((IFileObserver)this);
                this.isRegistered = true;
            }
        }

        private void unregisterDecorator(StatusDecorator decorator) {
            if (decorator == null) {
                return;
            }
            String decoratorViewId = decorator.getViewId();
            if (decoratorViewId == null) {
                return;
            }
            String bpmnId = decorator.getBpmnId();
            if (this.mapOfIdsToDecorators != null) {
                List list = (List)this.mapOfIdsToDecorators.get(decoratorViewId);
                if (list != null) {
                    list.remove((Object)decorator);
                    if (list.isEmpty()) {
                        this.mapOfIdsToDecorators.remove(decoratorViewId);
                        if (bpmnId != null) {
                            this.mapOfBpmnIdsToDecorators.remove(bpmnId);
                        }
                    }
                }
                if (this.mapOfIdsToDecorators.isEmpty()) {
                    this.mapOfIdsToDecorators = null;
                    this.mapOfBpmnIdsToDecorators = null;
                }
            }
            if (this.mapOfIdsToDecorators == null && this.isRegistered()) {
                FileChangeManager.getInstance().removeFileObserver((IFileObserver)this);
                this.isRegistered = false;
            }
        }

        public void handleFileRenamed(IFile oldFile, IFile file) {
        }

        public void handleFileMoved(IFile oldFile, IFile file) {
        }

        public void handleFileDeleted(IFile file) {
        }

        public void handleFileChanged(IFile file) {
        }

        public void handleMarkerAdded(IMarker marker) {
            if (marker.getAttribute(BpmnValidationDecoratorProvider.ELEMENT_ID, null) != null || marker.getAttribute(BpmnValidationDecoratorProvider.BPMN_ID, null) != null) {
                this.handleMarkerChanged(marker);
            }
        }

        public void handleMarkerDeleted(IMarker marker, Map attributes) {
            String bpmnId;
            List list;
            if (this.mapOfIdsToDecorators == null) {
                return;
            }
            String elementId = (String)attributes.get(BpmnValidationDecoratorProvider.ELEMENT_ID);
            List list2 = list = elementId != null ? (List)this.mapOfIdsToDecorators.get(elementId) : null;
            if (list == null && (bpmnId = (String)attributes.get(BpmnValidationDecoratorProvider.BPMN_ID)) != null) {
                list = (List)this.mapOfBpmnIdsToDecorators.get(bpmnId);
            }
            if (list != null && !list.isEmpty()) {
                this.refreshDecorators(list);
            }
        }

        public void handleMarkerChanged(IMarker marker) {
            String bpmnId;
            String elementId;
            List list;
            block5: {
                try {
                    if (this.mapOfIdsToDecorators == null || !marker.isSubtypeOf(BpmnValidationDecoratorProvider.MARKER_TYPE)) {
                        return;
                    }
                }
                catch (CoreException coreException) {
                    if (BpmnValidationDecoratorProvider.MARKER_TYPE.equals(this.getType(marker))) break block5;
                    return;
                }
            }
            List list2 = list = (elementId = marker.getAttribute(BpmnValidationDecoratorProvider.ELEMENT_ID, "")) != null ? (List)this.mapOfIdsToDecorators.get(elementId) : null;
            if (list == null && (bpmnId = marker.getAttribute(BpmnValidationDecoratorProvider.BPMN_ID, "")) != null) {
                list = (List)this.mapOfBpmnIdsToDecorators.get(bpmnId);
            }
            if (list != null && !list.isEmpty()) {
                this.refreshDecorators(list);
            }
        }

        private void refreshDecorators(List decorators) {
            final List decoratorsToRefresh = decorators;
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        if (TransactionUtil.getEditingDomain((EObject)MarkerObserver.this.diagramView) == null) {
                            return;
                        }
                        TransactionUtil.getEditingDomain((EObject)MarkerObserver.this.diagramView).runExclusive(new Runnable(){

                            public void run() {
                                for (IDecorator decorator : decoratorsToRefresh) {
                                    if (decorator == null) continue;
                                    decorator.refresh();
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        BpmnDiagramEditorPlugin.getInstance().logError("Decorator refresh failure", e);
                    }
                }
            });
        }

        private boolean isRegistered() {
            return this.isRegistered;
        }

        private String getType(IMarker marker) {
            try {
                return marker.getType();
            }
            catch (CoreException e) {
                BpmnDiagramEditorPlugin.getInstance().logError("Validation marker refresh failure", e);
                return "";
            }
        }
    }

    public static class StatusDecorator
    extends AbstractDecorator {
        private String viewId;
        private String bpmnId;

        public StatusDecorator(IDecoratorTarget decoratorTarget) {
            super(decoratorTarget);
            try {
                final View view = (View)this.getDecoratorTarget().getAdapter(View.class);
                final EObject semantic = BpmnValidationDecoratorProvider.resolveSemanticElement(decoratorTarget);
                TransactionUtil.getEditingDomain((EObject)view).runExclusive(new Runnable(){

                    public void run() {
                        StatusDecorator.this.viewId = view != null ? ViewUtil.getIdStr((View)view) : null;
                        StatusDecorator.this.bpmnId = semantic != null && semantic instanceof Identifiable ? ((Identifiable)semantic).getID() : null;
                    }
                });
            }
            catch (Exception e) {
                BpmnDiagramEditorPlugin.getInstance().logError("ViewID access failure", e);
            }
        }

        public void refresh() {
            this.removeDecoration();
            if (BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean(BpmnDiagramPreferenceInitializer.FILTER_DECORATIONS)) {
                return;
            }
            View view = (View)this.getDecoratorTarget().getAdapter(View.class);
            EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
            if (view == null || view.eResource() == null) {
                return;
            }
            IResource resource = StatusDecorator.getResource(view);
            if (resource == null || !resource.exists()) {
                return;
            }
            IMarker[] markers = null;
            try {
                markers = resource.findMarkers(BpmnValidationDecoratorProvider.MARKER_TYPE, true, 2);
            }
            catch (CoreException e) {
                BpmnDiagramEditorPlugin.getInstance().logError("Validation marker refresh failure", e);
            }
            if (markers == null || markers.length == 0) {
                return;
            }
            String elementId = ViewUtil.getIdStr((View)view);
            if (elementId == null) {
                return;
            }
            IMarker foundMarker = null;
            Label toolTip = null;
            int severity = 0;
            int i = 0;
            while (i < markers.length) {
                block22: {
                    IMarker marker = markers[i];
                    String attribute = marker.getAttribute(BpmnValidationDecoratorProvider.ELEMENT_ID, null);
                    if (attribute != null && attribute.equals(elementId) || (attribute = marker.getAttribute(BpmnValidationDecoratorProvider.BPMN_ID, null)) != null && attribute.equals(this.bpmnId)) {
                        block21: {
                            try {
                                if (!BpmnDecorationFilterService.getInstance().isMarkerFiltered(marker.getType(), marker.getAttribute("code"))) break block21;
                                break block22;
                            }
                            catch (CoreException coreException) {}
                        }
                        int nextSeverity = marker.getAttribute("severity", 0);
                        Image nextImage = this.getImage(nextSeverity);
                        if (foundMarker == null) {
                            foundMarker = marker;
                            toolTip = new Label(marker.getAttribute("message", ""), nextImage);
                        } else {
                            if (toolTip.getChildren().isEmpty()) {
                                Label comositeLabel = new Label();
                                FlowLayout fl = new FlowLayout(false);
                                fl.setMinorSpacing(0);
                                comositeLabel.setLayoutManager((LayoutManager)fl);
                                comositeLabel.add((IFigure)toolTip);
                                toolTip = comositeLabel;
                            }
                            toolTip.add((IFigure)new Label(marker.getAttribute("message", ""), nextImage));
                        }
                        severity = nextSeverity > severity ? nextSeverity : severity;
                    }
                }
                ++i;
            }
            if (foundMarker == null) {
                return;
            }
            if (editPart instanceof IGraphicalEditPart) {
                Image img = this.getImage(severity);
                if (view instanceof Edge) {
                    this.setDecoration(this.getDecoratorTarget().addConnectionDecoration(img, 50, true));
                } else {
                    int margin = -1;
                    if (editPart instanceof GraphicalEditPart) {
                        margin = MapModeUtil.getMapMode((IFigure)((IGraphicalEditPart)editPart).getFigure()).DPtoLP(margin);
                    }
                    if (editPart instanceof PoolEditPart) {
                        this.setDecoration(this.getDecoratorTarget().addShapeDecoration(img, IDecoratorTarget.Direction.NORTH_WEST, margin, true));
                    } else {
                        this.setDecoration(this.getDecoratorTarget().addShapeDecoration(img, IDecoratorTarget.Direction.NORTH_EAST, margin, true));
                    }
                }
                this.getDecoration().setToolTip(toolTip);
            }
        }

        private Image getImage(int severity) {
            String imageName = "IMG_OBJS_ERROR_TSK";
            switch (severity) {
                case 2: {
                    imageName = "IMG_OBJS_ERROR_TSK";
                    break;
                }
                case 1: {
                    imageName = "IMG_OBJS_WARN_TSK";
                    break;
                }
                default: {
                    imageName = "IMG_OBJS_INFO_TSK";
                }
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageName);
        }

        private static IResource getResource(View view) {
            Resource model = view.eResource();
            if (model != null) {
                return WorkspaceSynchronizer.getFile((Resource)model);
            }
            return null;
        }

        public void activate() {
            View view = (View)this.getDecoratorTarget().getAdapter(View.class);
            if (view == null) {
                return;
            }
            Diagram diagramView = view.getDiagram();
            if (diagramView == null) {
                return;
            }
            IFile file = WorkspaceSynchronizer.getFile((Resource)diagramView.eResource());
            if (file != null) {
                if (fileObserver == null) {
                    fileObserver = new MarkerObserver(diagramView);
                }
                fileObserver.registerDecorator(this);
            }
        }

        public void deactivate() {
            if (fileObserver != null) {
                fileObserver.unregisterDecorator(this);
                if (!fileObserver.isRegistered()) {
                    fileObserver = null;
                }
            }
            super.deactivate();
        }

        String getViewId() {
            return this.viewId;
        }

        String getBpmnId() {
            return this.bpmnId;
        }
    }
}

