/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.figures.activities;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.figures.activities.ActivityPainter;

public class ActivityFigure
extends Shape {
    private int _activityType = 0;
    private boolean isLooping;

    public void setActivityType(String type) {
        ActivityType at = ActivityType.get((String)type);
        this._activityType = at == null ? 0 : at.getValue();
        if (ActivityType.VALUES_EVENTS.contains(at)) {
            this.setMinimumSize(new Dimension(30, 30));
        } else if (ActivityType.VALUES_GATEWAYS.contains(at)) {
            this.setMinimumSize(new Dimension(50, 50));
        }
        this.revalidate();
        this.repaint();
    }

    public int getActivityType() {
        return this._activityType;
    }

    protected void fillShape(Graphics graphics) {
        if (this._activityType != 0) {
            ActivityPainter.paint(graphics, this);
        } else {
            graphics.fillRoundRectangle(this.getBounds(), 9, 9);
        }
    }

    protected void outlineShape(Graphics graphics) {
        if (this._activityType == 0) {
            Rectangle f = Rectangle.SINGLETON;
            Rectangle r = this.getBounds();
            f.x = r.x + this.lineWidth / 2;
            f.y = r.y + this.lineWidth / 2;
            f.width = r.width - this.lineWidth;
            f.height = r.height - this.lineWidth;
            graphics.drawRoundRectangle(f, 8, 8);
        }
    }

    public void paintFigure(Graphics graphics) {
        switch (this._activityType) {
            case 0: 
            case 1: {
                super.paintFigure(graphics);
                if (!this.isLooping) break;
                ActivityPainter.paintLoopInsideFigure(graphics, this.bounds, (IFigure)this);
                break;
            }
            default: {
                ActivityPainter.paint(graphics, this);
            }
        }
    }

    public boolean isLooping() {
        return this.isLooping;
    }

    public void setLooping(boolean isLooping) {
        this.isLooping = isLooping;
        this.revalidate();
        this.repaint();
    }
}

