/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.palette;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ToggleButton;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.stp.bpmn.palette.BpmnToolEntryEditPart;

class ToolEntryFigureInactiveToggleButton
extends ToggleButton {
    public boolean isSticky = false;
    private final BpmnToolEntryEditPart _part;

    ToolEntryFigureInactiveToggleButton(BpmnToolEntryEditPart part, IFigure contents) {
        super(contents);
        this._part = part;
        this.setOpaque(false);
        this.setEnabled(true);
    }

    public IFigure findMouseEventTargetAt(int x, int y) {
        return null;
    }

    public IFigure getToolTip() {
        return this._part.createToolTip();
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        if (this.isEnabled()) {
            this.setRolloverEnabled(true);
            this.setBorder(BpmnToolEntryEditPart.BORDER_TOGGLE);
            this.setForegroundColor(null);
        } else {
            this.setBorder(null);
            this.setRolloverEnabled(false);
            this.setForegroundColor(ColorConstants.gray);
        }
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isSelected() && this.isOpaque()) {
            this.fillCheckeredRectangle(graphics);
        } else {
            super.paintFigure(graphics);
        }
    }

    protected void fillCheckeredRectangle(Graphics graphics) {
        Rectangle rect = this.getClientArea(Rectangle.SINGLETON).crop(new Insets(1, 1, 0, 0));
        if (this.isSticky) {
            graphics.setLineWidth(3);
            graphics.setForegroundColor(ColorConstants.black);
            graphics.drawRectangle(rect);
            graphics.setLineWidth(1);
        }
        graphics.setBackgroundColor(this._part._backgroundColor);
        graphics.setForegroundColor(this._part._foregroundColor);
        graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
        graphics.clipRect(rect);
        graphics.translate(rect.x, rect.y);
        int n = rect.width + rect.height;
        int i = 1;
        while (i < n) {
            graphics.drawLine(0, i, i, 0);
            i += 2;
        }
        graphics.restoreState();
    }
}

